/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.rx;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import org.mule.runtime.core.internal.util.rx.FluxSinkSupplier;
import reactor.core.publisher.FluxSink;

public class RoundRobinFluxSinkSupplier<T>
implements FluxSinkSupplier<T> {
    private final List<FluxSink<T>> fluxSinks;
    private final AtomicInteger index = new AtomicInteger(0);
    private final IntUnaryOperator update;

    public RoundRobinFluxSinkSupplier(int size, Supplier<FluxSink<T>> sinkFactory) {
        ArrayList<FluxSink<T>> sinks = new ArrayList<FluxSink<T>>(size);
        for (int i = 0; i < size; ++i) {
            FluxSink<T> sink = sinkFactory.get();
            if (sink == null) continue;
            sinks.add(sink);
        }
        this.fluxSinks = sinks;
        this.update = value -> (value + 1) % this.fluxSinks.size();
    }

    private int nextIndex() {
        return this.index.getAndUpdate(this.update);
    }

    public void dispose() {
        this.fluxSinks.forEach(FluxSink::complete);
    }

    @Override
    public FluxSink<T> get() {
        return this.fluxSinks.get(this.nextIndex());
    }
}

