/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.queue;

import org.mule.runtime.api.queue.Queue;
import org.mule.runtime.api.queue.QueueSession;
import org.mule.runtime.core.api.lifecycle.LifecycleState;
import org.mule.runtime.core.internal.util.queue.QueueProvider;
import org.mule.runtime.core.internal.util.queue.QueueStore;
import org.mule.runtime.core.internal.util.queue.QueueTransactionContext;
import org.mule.runtime.core.internal.util.queue.TransactionAwareQueueStore;
import org.mule.runtime.core.internal.util.queue.TransactionContextProvider;

public abstract class AbstractQueueSession
implements QueueSession {
    private final QueueProvider queueProvider;
    private final LifecycleState deploymentLifecycleState;

    protected AbstractQueueSession(QueueProvider queueProvider, LifecycleState deploymentLifecycleState) {
        this.queueProvider = queueProvider;
        this.deploymentLifecycleState = deploymentLifecycleState;
    }

    public Queue getQueue(String name) {
        QueueStore queueStore = this.queueProvider.getQueue(name);
        return new TransactionAwareQueueStore(queueStore, new TransactionContextProvider(){

            @Override
            public boolean isTransactional() {
                return this.getTransactionalContext() != null;
            }

            @Override
            public QueueTransactionContext getTransactionalContext() {
                return AbstractQueueSession.this.getTransactionalContext();
            }
        }, this.deploymentLifecycleState);
    }

    protected QueueProvider getQueueProvider() {
        return this.queueProvider;
    }

    protected abstract QueueTransactionContext getTransactionalContext();
}

