/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.message;

import java.util.Optional;
import java.util.OptionalLong;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.sdk.api.runtime.operation.Result;

public class EventedSdkResult<T, A>
extends Result<T, A> {
    private final CoreEvent event;

    protected EventedSdkResult(CoreEvent event) {
        this.event = event;
    }

    public static <T, A> EventedSdkResult<T, A> from(CoreEvent event) {
        return new EventedSdkResult<T, A>(event);
    }

    public CoreEvent getEvent() {
        return this.event;
    }

    public Result.Builder<T, A> copy() {
        final CoreEvent.Builder product = CoreEvent.builder(this.event);
        final Message.Builder message = Message.builder((Message)this.event.getMessage());
        return new Result.Builder<T, A>(){

            public Result.Builder<T, A> output(T output) {
                message.payload(TypedValue.of(output));
                return this;
            }

            public Result.Builder<T, A> attributes(A attributes) {
                message.attributes(TypedValue.of(attributes));
                return this;
            }

            public Result.Builder<T, A> mediaType(MediaType mediaType) {
                message.mediaType(mediaType);
                return this;
            }

            public Result.Builder<T, A> attributesMediaType(MediaType mediaType) {
                message.attributesMediaType(mediaType);
                return this;
            }

            public Result<T, A> build() {
                return EventedSdkResult.from(product.message(message.build()).build());
            }
        };
    }

    public T getOutput() {
        return (T)this.event.getMessage().getPayload().getValue();
    }

    public Optional<A> getAttributes() {
        return Optional.ofNullable(this.event.getMessage().getAttributes().getValue());
    }

    public Optional<MediaType> getMediaType() {
        return Optional.ofNullable(this.event.getMessage().getPayload().getDataType().getMediaType());
    }

    public Optional<MediaType> getAttributesMediaType() {
        return Optional.ofNullable(this.event.getMessage().getAttributes().getDataType().getMediaType());
    }

    public OptionalLong getByteLength() {
        return this.event.getMessage().getPayload().getByteLength();
    }
}

