/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.journal.queue;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.mule.runtime.api.serialization.SerializationProtocol;
import org.mule.runtime.core.internal.util.journal.JournalEntrySerializer;
import org.mule.runtime.core.internal.util.journal.queue.AbstractQueueTransactionJournal;
import org.mule.runtime.core.internal.util.journal.queue.LocalQueueTxJournalEntry;

public class LocalTxQueueTransactionJournal
extends AbstractQueueTransactionJournal<Integer, LocalQueueTxJournalEntry> {
    public LocalTxQueueTransactionJournal(String logFilesDirectory, SerializationProtocol serializer, int maximumFileSizeInMegabytes) {
        super(logFilesDirectory, LocalTxQueueTransactionJournal.createLocalTxQueueJournalEntrySerializer(serializer), maximumFileSizeInMegabytes);
    }

    public LocalTxQueueTransactionJournal(String logFilesDirectory, SerializationProtocol serializer) {
        super(logFilesDirectory, LocalTxQueueTransactionJournal.createLocalTxQueueJournalEntrySerializer(serializer), null);
    }

    public static JournalEntrySerializer<Integer, LocalQueueTxJournalEntry> createLocalTxQueueJournalEntrySerializer(final SerializationProtocol serializer) {
        return new JournalEntrySerializer<Integer, LocalQueueTxJournalEntry>(){

            @Override
            public LocalQueueTxJournalEntry deserialize(DataInputStream inputStream) throws IOException {
                return new LocalQueueTxJournalEntry(inputStream, serializer);
            }

            @Override
            public void serialize(LocalQueueTxJournalEntry journalEntry, DataOutputStream dataOutputStream) {
                journalEntry.write(dataOutputStream, serializer);
            }
        };
    }

    @Override
    protected LocalQueueTxJournalEntry createUpdateJournalEntry(Integer txId, byte byteRepresentation, String queueName, Serializable value) {
        return new LocalQueueTxJournalEntry(txId, byteRepresentation, queueName, value);
    }

    @Override
    protected LocalQueueTxJournalEntry createCheckpointJournalEntry(Integer txId, byte operation) {
        return new LocalQueueTxJournalEntry(txId, operation);
    }
}

