/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.transformer.AbstractTransformer;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.transformer.TransformersRegistry;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTransformer.class);
    public static final String COMMA = ",";

    @Deprecated
    public static void initialiseAllTransformers(List<Transformer> transformers) throws InitialisationException {
        if (transformers != null) {
            Iterator<Transformer> transformer = transformers.iterator();
            while (transformer.hasNext()) {
                transformer.next().initialise();
            }
        }
    }

    public static String toString(List<Transformer> transformers) {
        StringBuilder buffer = new StringBuilder();
        Iterator<Transformer> transformer = transformers.iterator();
        while (transformer.hasNext()) {
            buffer.append(transformer.next().toString());
            if (!transformer.hasNext()) continue;
            buffer.append(" -> ");
        }
        return buffer.toString();
    }

    public static Transformer firstOrNull(List<Transformer> transformers) {
        if (transformers != null && 0 != transformers.size()) {
            return transformers.get(0);
        }
        return null;
    }

    public static List<Transformer> getTransformers(String names, MuleContext muleContext) throws MuleException {
        if (null != names) {
            LinkedList<Transformer> transformers = new LinkedList<Transformer>();
            StringTokenizer st = new StringTokenizer(names, COMMA);
            while (st.hasMoreTokens()) {
                String key = st.nextToken().trim();
                Transformer transformer = (Transformer)((MuleContextWithRegistry)muleContext).getRegistry().lookupObject(key);
                if (transformer == null) {
                    throw new DefaultMuleException(CoreMessages.objectNotRegistered("Transformer", key));
                }
                transformers.add(transformer);
            }
            return transformers;
        }
        return null;
    }

    public static void checkTransformerReturnClass(Transformer transformer, Object value) throws TransformerException {
        if (value == null && transformer instanceof AbstractTransformer && ((AbstractTransformer)transformer).isAllowNullReturn()) {
            return;
        }
        if (transformer.getReturnDataType() != null) {
            DataType dt = DataType.builder().fromObject(value).mediaType(transformer.getReturnDataType().getMediaType()).build();
            if (!transformer.getReturnDataType().isCompatibleWith(dt)) {
                throw new TransformerException(CoreMessages.transformUnexpectedType(dt, transformer.getReturnDataType()), transformer);
            }
        }
        LOGGER.debug("The transformed value is of expected type. Type is: {}", value == null ? Object.class : value.getClass());
    }

    @Deprecated
    public static <T> Object transformToAny(T input, MuleContext muleContext, DataType ... supportedTypes) {
        DataType supportedType;
        TransformersRegistry transformersRegistry;
        DataType sourceType = DataType.fromType(input.getClass());
        Object transformedData = null;
        try {
            transformersRegistry = ((MuleContextWithRegistry)muleContext).getRegistry().lookupObject(TransformersRegistry.class);
        }
        catch (RegistrationException e) {
            throw new MuleRuntimeException((Throwable)((Object)e));
        }
        DataType[] dataTypeArray = supportedTypes;
        int n = dataTypeArray.length;
        for (int i = 0; i < n && (transformedData = TransformerUtils.attemptTransformation(sourceType, input, supportedType = dataTypeArray[i], transformersRegistry)) == null; ++i) {
        }
        return transformedData;
    }

    private static <S, R> R attemptTransformation(DataType sourceDataType, S source, DataType resultDataType, TransformersRegistry transformersRegistry) {
        Transformer transformer;
        try {
            transformer = transformersRegistry.lookupTransformer(sourceDataType, resultDataType);
        }
        catch (TransformerException e) {
            LOGGER.debug("Could not find a transformer from type {} to {}", (Object)sourceDataType.getType().getName(), (Object)resultDataType.getType().getName());
            return null;
        }
        LOGGER.debug("Located transformer {} from type {} to type {}. Attempting transformation...", new Object[]{transformer.getName(), sourceDataType.getType().getName(), resultDataType.getType().getName()});
        try {
            return (R)transformer.transform(source);
        }
        catch (TransformerException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Transformer %s threw exception while trying to transform an object of type %s into a %s", transformer.getName(), sourceDataType.getType().getName(), resultDataType.getType().getName()), (Throwable)((Object)e));
            }
            return null;
        }
    }

    public static String generateTransformerName(Class<? extends Transformer> transformerClass, DataType returnType) {
        Object transformerName = transformerClass.getSimpleName();
        int i = ((String)transformerName).indexOf("To");
        if (i > 0 && returnType != null) {
            String target = returnType.getType().getSimpleName();
            if (target.equals("byte[]")) {
                target = "byteArray";
            }
            transformerName = ((String)transformerName).substring(0, i + 2) + StringUtils.capitalize((String)target);
        }
        return transformerName;
    }
}

