/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.object.iterator;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.mule.runtime.api.store.ObjectDoesNotExistException;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.core.api.streaming.iterator.Producer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectStoreProducer<T extends Serializable>
implements Producer<T> {
    private static final Logger logger = LoggerFactory.getLogger(ObjectStoreProducer.class);
    private ObjectStore<T> objectStore;
    private Iterator<String> keys;
    private int size;

    public ObjectStoreProducer(ObjectStore<T> objectStore) {
        if (objectStore == null) {
            throw new IllegalArgumentException("Cannot construct a producer with a null object store");
        }
        this.objectStore = objectStore;
        try {
            ArrayList allKeys = new ArrayList(objectStore.allKeys());
            this.keys = allKeys.iterator();
            this.size = allKeys.size();
        }
        catch (ObjectStoreException e) {
            throw new RuntimeException("Could not construct producer because exception was found retrieving keys", e);
        }
    }

    @Override
    public T produce() {
        if (this.objectStore == null || !this.keys.hasNext()) {
            return null;
        }
        String key = this.keys.next();
        try {
            return (T)this.objectStore.retrieve(key);
        }
        catch (ObjectDoesNotExistException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("key %s no longer available in objectstore. This is likely due to a concurrency issue. Will continue with next key if available", key));
            }
            return (T)this.produce();
        }
        catch (ObjectStoreException e) {
            throw new RuntimeException(e);
        }
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public void close() throws IOException {
        this.objectStore = null;
        this.keys = null;
    }
}

