/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.core.api.streaming.bytes.ManagedByteBufferWrapper;
import org.mule.runtime.core.internal.streaming.DefaultMemoryManager;
import org.mule.runtime.core.internal.streaming.MemoryManager;
import org.mule.runtime.core.internal.streaming.bytes.ByteStreamingConstants;
import org.mule.runtime.core.internal.streaming.bytes.MemoryBoundByteBufferManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vibur.objectpool.ConcurrentPool;
import org.vibur.objectpool.PoolObjectFactory;
import org.vibur.objectpool.PoolService;
import org.vibur.objectpool.util.ConcurrentCollection;
import org.vibur.objectpool.util.MultithreadConcurrentQueueCollection;

public class PoolingByteBufferManager
extends MemoryBoundByteBufferManager
implements Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PoolingByteBufferManager.class);
    private final int size;
    private BufferPool defaultSizePool;
    private final LoadingCache<Integer, BufferPool> customSizePools = Caffeine.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).removalListener((key, value, cause) -> {
        block2: {
            try {
                value.close();
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug("Found exception trying to dispose buffer pool for capacity " + key, (Throwable)e);
            }
        }
    }).build(this::newBufferPool);

    public PoolingByteBufferManager() {
        this(new DefaultMemoryManager(), ByteStreamingConstants.DEFAULT_BUFFER_POOL_SIZE, ByteStreamingConstants.DEFAULT_BUFFER_BUCKET_SIZE);
    }

    public PoolingByteBufferManager(MemoryManager memoryManager, int size, int bufferSize) {
        super(memoryManager);
        this.size = size;
        this.defaultSizePool = this.newBufferPool(bufferSize);
    }

    private BufferPool newBufferPool(Integer capacity) {
        return new BufferPool(this.size, capacity);
    }

    private BufferPool getBufferPool(int capacity) {
        return capacity == ByteStreamingConstants.DEFAULT_BUFFER_BUCKET_SIZE ? this.defaultSizePool : (BufferPool)this.customSizePools.get((Object)capacity);
    }

    @Override
    public ManagedByteBufferWrapper allocateManaged(int capacity) {
        try {
            return this.getBufferPool(capacity).take();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not allocate byte buffer. " + e.getMessage())), (Throwable)e);
        }
    }

    public void dispose() {
        block5: {
            block4: {
                try {
                    this.defaultSizePool.close();
                }
                catch (Exception e) {
                    if (!LOGGER.isWarnEnabled()) break block4;
                    LOGGER.warn("Error disposing default capacity byte buffers pool", (Throwable)e);
                }
            }
            try {
                this.customSizePools.invalidateAll();
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) break block5;
                LOGGER.warn("Error disposing mixed capacity byte buffers pool", (Throwable)e);
            }
        }
    }

    private class BufferPool {
        private final PoolService<ManagedByteBufferWrapper> pool;
        private final PoolObjectFactory<ManagedByteBufferWrapper> factory;
        private final int bufferCapacity;

        private BufferPool(int size, final int bufferCapacity) {
            this.bufferCapacity = bufferCapacity;
            this.factory = new PoolObjectFactory<ManagedByteBufferWrapper>(){

                public ManagedByteBufferWrapper create() {
                    return new ManagedByteBufferWrapper(PoolingByteBufferManager.this.allocateIfFits(bufferCapacity), buffer -> BufferPool.this.returnBuffer((ManagedByteBufferWrapper)buffer));
                }

                public boolean readyToTake(ManagedByteBufferWrapper buffer) {
                    return true;
                }

                public boolean readyToRestore(ManagedByteBufferWrapper buffer) {
                    buffer.getDelegate().clear();
                    return true;
                }

                public void destroy(ManagedByteBufferWrapper buffer) {
                    PoolingByteBufferManager.this.doDeallocate(buffer.getDelegate());
                }
            };
            this.pool = new ConcurrentPool((ConcurrentCollection)new MultithreadConcurrentQueueCollection(size), this.factory, Math.min(Runtime.getRuntime().availableProcessors(), size), size, false);
        }

        private ManagedByteBufferWrapper take() {
            ManagedByteBufferWrapper buffer = (ManagedByteBufferWrapper)this.pool.tryTake();
            if (buffer == null) {
                buffer = new ManagedByteBufferWrapper(PoolingByteBufferManager.this.allocateIfFits(this.bufferCapacity), b -> PoolingByteBufferManager.this.doDeallocate(b.getDelegate()));
            }
            return buffer;
        }

        private void returnBuffer(ManagedByteBufferWrapper buffer) {
            this.pool.restore((Object)buffer);
        }

        private void close() {
            this.pool.close();
        }
    }
}

