/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes;

import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.api.streaming.bytes.ByteStreamingManager;
import org.mule.runtime.core.api.streaming.bytes.CursorStreamProviderFactory;
import org.mule.runtime.core.api.streaming.bytes.InMemoryCursorStreamConfig;
import org.mule.runtime.core.api.streaming.bytes.factory.InMemoryCursorStreamProviderFactory;
import org.mule.runtime.core.internal.streaming.bytes.factory.NullCursorStreamProviderFactory;

public class DefaultByteStreamingManager
implements ByteStreamingManager {
    private final ByteBufferManager bufferManager;
    protected final StreamingManager streamingManager;
    private final FeatureFlaggingService ffService;

    public DefaultByteStreamingManager(ByteBufferManager bufferManager, StreamingManager streamingManager, FeatureFlaggingService ffService) {
        this.bufferManager = bufferManager;
        this.streamingManager = streamingManager;
        this.ffService = ffService;
    }

    @Override
    public CursorStreamProviderFactory getInMemoryCursorProviderFactory(InMemoryCursorStreamConfig config) {
        return new InMemoryCursorStreamProviderFactory(this.bufferManager, config, this.streamingManager);
    }

    @Override
    public CursorStreamProviderFactory getNullCursorProviderFactory() {
        return new NullCursorStreamProviderFactory(this.bufferManager, this.streamingManager);
    }

    @Override
    public CursorStreamProviderFactory getDefaultCursorProviderFactory() {
        return new InMemoryCursorStreamProviderFactory(this.bufferManager, InMemoryCursorStreamConfig.getDefault(this.isEagerReadFeatureEnabled()), this.streamingManager);
    }

    protected ByteBufferManager getBufferManager() {
        return this.bufferManager;
    }

    protected boolean isEagerReadFeatureEnabled() {
        return this.ffService.isEnabled((Feature)MuleRuntimeFeature.ENABLE_REPEATABLE_STREAMING_BYTES_EAGER_READ);
    }
}

