/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming;

import java.util.concurrent.atomic.AtomicInteger;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.core.internal.streaming.CursorProviderDecorator;
import org.mule.runtime.core.internal.streaming.CursorProviderJanitor;
import org.mule.runtime.core.internal.streaming.IdentifiableCursorProvider;
import org.mule.runtime.core.internal.streaming.MutableStreamingStatistics;

public abstract class ManagedCursorProvider<T extends Cursor>
extends CursorProviderDecorator<T>
implements IdentifiableCursorProvider<T> {
    private final AtomicInteger openCursorsCount = new AtomicInteger(0);
    private final MutableStreamingStatistics statistics;
    private final CursorProviderJanitor janitor;
    private final int id;

    protected ManagedCursorProvider(IdentifiableCursorProvider<T> delegate, MutableStreamingStatistics statistics) {
        super(delegate);
        this.id = delegate.getId();
        this.janitor = new CursorProviderJanitor(delegate, this.openCursorsCount, statistics);
        this.statistics = statistics;
        if (statistics != null) {
            statistics.incrementOpenProviders();
        }
    }

    @Override
    public final T openCursor() {
        Cursor cursor = this.delegate.openCursor();
        this.openCursorsCount.incrementAndGet();
        if (this.statistics != null) {
            this.statistics.incrementOpenCursors();
        }
        return (T)this.managedCursor(cursor);
    }

    protected abstract T managedCursor(T var1);

    @Override
    public final void releaseResources() {
        this.janitor.releaseResources();
    }

    @Override
    public int getId() {
        return this.id;
    }

    public CursorProviderJanitor getJanitor() {
        return this.janitor;
    }

    @Override
    public void close() {
        this.janitor.close();
    }
}

