/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import org.mule.runtime.api.component.location.ComponentLocation;

public class CursorProviderAlreadyClosedException
extends RuntimeException {
    private final Optional<ComponentLocation> originatingLocation;

    public CursorProviderAlreadyClosedException(String message) {
        this(message, Optional.empty());
    }

    public CursorProviderAlreadyClosedException(String message, Optional<ComponentLocation> originatingLocation) {
        this(message, originatingLocation, Optional.empty());
    }

    public CursorProviderAlreadyClosedException(String message, Optional<ComponentLocation> originatingLocation, Optional<Exception> closerResponsible) {
        super(CursorProviderAlreadyClosedException.resolveMessage(message, originatingLocation, closerResponsible));
        this.originatingLocation = originatingLocation;
    }

    public Optional<ComponentLocation> getOriginatingLocation() {
        return this.originatingLocation;
    }

    private static String resolveMessage(String message, Optional<ComponentLocation> originatingLocation, Optional<Exception> closerResponsible) {
        String openedByDescription = String.format("The cursor provider was open by %s", originatingLocation.map(cl -> cl.getLocation()).orElse("unknown"));
        String responsibleDescription = closerResponsible.map(r -> {
            StringWriter stringWriter = new StringWriter();
            r.printStackTrace(new PrintWriter(stringWriter));
            return String.format("The cursor provider was closed by: \n %s", stringWriter.toString());
        }).orElse(String.format("Set SystemProperty '%s' in true for more details", "mule.track.cursorProvider.close"));
        return String.format("%s: %s. %s.", message, openedByDescription, responsibleDescription);
    }
}

