/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.mule.runtime.core.internal.processor.strategy.AbstractDelegatingScheduledExecutor;
import org.mule.runtime.core.internal.util.ClassUtils;
import org.slf4j.MDC;

public class PreservingThreadContextExecutorServiceWrapper
extends AbstractDelegatingScheduledExecutor {
    public PreservingThreadContextExecutorServiceWrapper(ScheduledExecutorService delegate) {
        super(delegate);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.delegate.schedule(new DecoratedRunnable(command), delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.delegate.schedule(new DecoratedCallable<V>(callable), delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.delegate.scheduleAtFixedRate(new DecoratedRunnable(command), initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.delegate.scheduleWithFixedDelay(new DecoratedRunnable(command), initialDelay, delay, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(new DecoratedCallable<T>(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.delegate.submit(new DecoratedRunnable(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.delegate.submit(new DecoratedRunnable(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(tasks.stream().map(DecoratedCallable::new).toList());
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(tasks.stream().map(DecoratedCallable::new).toList(), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(tasks.stream().map(DecoratedCallable::new).toList());
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(tasks.stream().map(DecoratedCallable::new).toList(), timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(new DecoratedRunnable(command));
    }

    private static class DecoratedRunnable
    implements Runnable {
        private final Runnable delegate;
        private final ClassLoader savedClassLoader;
        private final Map<String, String> savedMDC;

        public DecoratedRunnable(Runnable delegate) {
            this.delegate = delegate;
            this.savedClassLoader = Thread.currentThread().getContextClassLoader();
            this.savedMDC = MDC.getCopyOfContextMap();
        }

        @Override
        public void run() {
            try (ThreadContext ignored = new ThreadContext(this.savedClassLoader, this.savedMDC);){
                this.delegate.run();
            }
        }
    }

    private static class DecoratedCallable<V>
    implements Callable<V> {
        private final Callable<V> delegate;
        private final ClassLoader savedClassLoader;
        private final Map<String, String> savedMDC;

        public DecoratedCallable(Callable<V> delegate) {
            this.delegate = delegate;
            this.savedClassLoader = Thread.currentThread().getContextClassLoader();
            this.savedMDC = MDC.getCopyOfContextMap();
        }

        @Override
        public V call() throws Exception {
            try (ThreadContext ignored = new ThreadContext(this.savedClassLoader, this.savedMDC);){
                V v = this.delegate.call();
                return v;
            }
        }
    }

    private static class ThreadContext
    implements AutoCloseable {
        private final Thread currentThread = Thread.currentThread();
        private final ClassLoader innerClassLoader;
        private final Map<String, String> innerMDC;
        private final ClassLoader outerClassLoader;
        private final Map<String, String> outerMDC;

        ThreadContext(ClassLoader classLoader, Map<String, String> mdc) {
            this.innerClassLoader = classLoader;
            this.innerMDC = mdc;
            this.outerClassLoader = this.currentThread.getContextClassLoader();
            this.outerMDC = MDC.getCopyOfContextMap();
            MDC.setContextMap(this.innerMDC);
            ClassUtils.setContextClassLoader(this.currentThread, this.outerClassLoader, this.innerClassLoader);
        }

        @Override
        public void close() {
            try {
                ClassUtils.setContextClassLoader(this.currentThread, this.innerClassLoader, this.outerClassLoader);
            }
            finally {
                MDC.setContextMap(this.outerMDC);
            }
        }
    }
}

