/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.interceptor;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.interception.FlowInterceptor;
import org.mule.runtime.api.interception.InterceptionAction;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorParameterValue;
import org.mule.runtime.core.internal.interception.DefaultInterceptionEvent;
import org.mule.runtime.core.internal.processor.interceptor.ComponentInterceptorAdapter;
import org.mule.runtime.core.internal.processor.interceptor.ReactiveInterceptionAction;

class FlowInterceptorWrapper
implements ComponentInterceptorAdapter {
    private static final String BEFORE_METHOD_NAME = "before";
    private static final String AFTER_METHOD_NAME = "after";
    private static final String AROUND_METHOD_NAME = "around";
    private final FlowInterceptor flowInterceptor;

    public FlowInterceptorWrapper(FlowInterceptor flowInterceptor) {
        this.flowInterceptor = flowInterceptor;
    }

    @Override
    public boolean implementsBeforeOrAfter() {
        try {
            return !this.flowInterceptor.getClass().getMethod(BEFORE_METHOD_NAME, String.class, InterceptionEvent.class).isDefault() || !this.flowInterceptor.getClass().getMethod(AFTER_METHOD_NAME, String.class, InterceptionEvent.class, Optional.class).isDefault();
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean implementsAround() {
        try {
            return !this.flowInterceptor.getClass().getMethod(AROUND_METHOD_NAME, String.class, InterceptionEvent.class, InterceptionAction.class).isDefault();
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    @Override
    public void before(ComponentLocation location, Map<String, ProcessorParameterValue> resolvedParams, DefaultInterceptionEvent interceptionEvent) {
        this.flowInterceptor.before(location.getRootContainerName(), (InterceptionEvent)interceptionEvent);
    }

    @Override
    public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> resolvedParams, DefaultInterceptionEvent interceptionEvent, ReactiveInterceptionAction reactiveInterceptionAction) {
        return this.flowInterceptor.around(location.getRootContainerName(), (InterceptionEvent)interceptionEvent, (InterceptionAction)reactiveInterceptionAction);
    }

    @Override
    public void after(ComponentLocation location, DefaultInterceptionEvent interceptionEvent, Optional<Throwable> thrown) {
        this.flowInterceptor.after(location.getRootContainerName(), (InterceptionEvent)interceptionEvent, thrown);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.flowInterceptor.getClass().getClassLoader();
    }
}

