/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.function.Function;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.policy.Policy;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.policy.PolicyEventMapper;
import org.mule.runtime.core.internal.policy.PolicyTraceLogger;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class SourcePolicyProcessor
implements ReactiveProcessor {
    private final Policy policy;
    private final Reference<ReactiveProcessor> nextProcessorRef;
    private final PolicyEventMapper policyEventMapper;
    private final PolicyTraceLogger policyTraceLogger;

    public SourcePolicyProcessor(Policy policy, ReactiveProcessor nextProcessor) {
        this.policy = policy;
        this.nextProcessorRef = new WeakReference<ReactiveProcessor>(nextProcessor);
        this.policyEventMapper = new PolicyEventMapper(policy.getPolicyId());
        this.policyTraceLogger = new PolicyTraceLogger();
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return Flux.from(publisher).map(this.policyEventMapper::onSourcePolicyBegin).doOnNext(event -> this.policyTraceLogger.logSourcePolicyStart(this.policy, (CoreEvent)event)).transform((Function)this.policy.getPolicyChain()).doOnNext(event -> this.policyTraceLogger.logSourcePolicyEnd(this.policy, (CoreEvent)event)).contextWrite(ctx -> ctx.put((Object)"policy.nextOperation", this.nextProcessorRef).put((Object)"policy.isPropagateMessageTransformations", (Object)this.policy.getPolicyChain().isPropagateMessageTransformations()));
    }
}

