/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.LocationPart;
import org.mule.runtime.core.api.context.notification.FlowStackElement;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.policy.PolicyNotificationHelper;
import org.mule.runtime.core.privileged.event.DefaultFlowCallStack;
import org.mule.runtime.core.privileged.exception.MessagingException;

public class OnExecuteNextErrorConsumer
implements Consumer<Throwable> {
    private final Function<MessagingException, CoreEvent> prepareEvent;
    private final PolicyNotificationHelper notificationHelper;
    private final ComponentLocation location;
    private final Map<QName, Object> annotations;

    public OnExecuteNextErrorConsumer(Function<MessagingException, CoreEvent> prepareEvent, PolicyNotificationHelper notificationHelper, ComponentLocation location, Map<QName, Object> annotations) {
        this.prepareEvent = prepareEvent;
        this.notificationHelper = notificationHelper;
        this.location = location;
        this.annotations = annotations;
    }

    @Override
    public void accept(Throwable error) {
        MessagingException me = (MessagingException)((Object)error);
        CoreEvent newEvent = this.prepareEvent.apply(me);
        me.setProcessedEvent(newEvent);
        this.notificationHelper.fireNotification(newEvent, (Exception)((Object)me), 2103);
        this.pushAfterNextFlowStackElement().accept(newEvent);
    }

    private Consumer<CoreEvent> pushAfterNextFlowStackElement() {
        return event -> ((DefaultFlowCallStack)event.getFlowCallStack()).push(new FlowStackElement(this.toPolicyLocation(this.location), null, this.location, this.annotations));
    }

    private String toPolicyLocation(ComponentLocation componentLocation) {
        return ((LocationPart)componentLocation.getParts().get(0)).getPartPath() + "/" + ((LocationPart)componentLocation.getParts().get(1)).getPartPath() + "[after next]";
    }
}

