/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.Optional;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.policy.PolicyChain;
import org.mule.runtime.core.api.policy.PolicyInstance;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.lifecycle.DefaultLifecycleManager;
import org.mule.runtime.core.internal.profiling.InternalProfilingService;
import org.mule.runtime.core.internal.util.UUID;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoExtend
public class DefaultPolicyInstance
extends AbstractComponent
implements PolicyInstance,
MuleContextAware,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPolicyInstance.class);
    private ProcessingStrategy processingStrategy;
    private String name;
    private PolicyChain operationPolicyChain;
    private PolicyChain sourcePolicyChain;
    private MuleContext muleContext;
    private final DefaultLifecycleManager<DefaultPolicyInstance> lifecycleStateManager = new DefaultLifecycleManager<DefaultPolicyInstance>("proxy-policy-" + UUID.getUUID(), this);

    public void initialise() throws InitialisationException {
        try {
            this.processingStrategy = this.defaultProcessingStrategy().create(((MuleContextWithRegistry)this.muleContext).getRegistry().lookupObject(InternalProfilingService.class), ((MuleContextWithRegistry)this.muleContext).getRegistry().lookupObject(FeatureFlaggingService.class), this.muleContext.getSchedulerService(), this.muleContext::getSchedulerBaseConfig, this.getName(), this.muleContext.getConfiguration().getId(), ArtifactType.valueOf((String)this.muleContext.getArtifactType().name()), () -> this.muleContext.getConfiguration().getShutdownTimeout());
        }
        catch (RegistrationException e) {
            throw new InitialisationException((Throwable)((Object)e), (Initialisable)this);
        }
        LifecycleUtils.initialiseIfNeeded(this.processingStrategy);
        if (this.operationPolicyChain != null) {
            this.operationPolicyChain.setProcessingStrategy(this.processingStrategy);
        }
        if (this.sourcePolicyChain != null) {
            this.sourcePolicyChain.setProcessingStrategy(this.processingStrategy);
        }
        LifecycleUtils.initialiseIfNeeded((Object)this.operationPolicyChain, this.muleContext.getInjector());
        LifecycleUtils.initialiseIfNeeded((Object)this.sourcePolicyChain, this.muleContext.getInjector());
        this.lifecycleStateManager.fireInitialisePhase((phaseNam, object) -> {});
    }

    private ProcessingStrategyFactory defaultProcessingStrategy() {
        return MessageProcessors.getDefaultProcessingStrategyFactory(this.muleContext.getConfiguration());
    }

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.processingStrategy);
        LifecycleUtils.startIfNeeded(this.operationPolicyChain);
        LifecycleUtils.startIfNeeded(this.sourcePolicyChain);
        this.lifecycleStateManager.fireStartPhase((phaseNam, object) -> {});
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.operationPolicyChain, LOGGER);
        LifecycleUtils.disposeIfNeeded(this.sourcePolicyChain, LOGGER);
        LifecycleUtils.disposeIfNeeded(this.processingStrategy, LOGGER);
        this.lifecycleStateManager.fireDisposePhase((phaseNam, object) -> {});
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.operationPolicyChain);
        LifecycleUtils.stopIfNeeded(this.sourcePolicyChain);
        LifecycleUtils.stopIfNeeded(this.processingStrategy);
        this.lifecycleStateManager.fireStopPhase((phaseNam, object) -> {});
    }

    public void setOperationPolicyChain(PolicyChain request) {
        this.operationPolicyChain = request;
    }

    public void setSourcePolicyChain(PolicyChain source) {
        this.sourcePolicyChain = source;
    }

    @Override
    public Optional<PolicyChain> getSourcePolicyChain() {
        return Optional.ofNullable(this.sourcePolicyChain);
    }

    @Override
    public Optional<PolicyChain> getOperationPolicyChain() {
        return Optional.ofNullable(this.operationPolicyChain);
    }

    @Override
    public ProcessingStrategy getProcessingStrategy() {
        return this.processingStrategy;
    }
}

