/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.function.Supplier;
import org.mule.runtime.api.component.execution.CompletableCallback;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.policy.MessageSourceResponseParametersProcessor;
import org.mule.runtime.core.internal.policy.SourcePolicy;
import org.mule.runtime.core.internal.policy.SourcePolicyContext;
import org.mule.runtime.core.internal.policy.SourcePolicyFailureResult;
import org.mule.runtime.core.internal.policy.SourcePolicySuccessResult;
import org.mule.runtime.core.internal.util.rx.FluxSinkSupplier;
import org.mule.runtime.core.internal.util.rx.RoundRobinFluxSinkSupplier;
import org.mule.runtime.core.internal.util.rx.TransactionAwareFluxSinkSupplier;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import reactor.core.publisher.FluxSink;

class CommonSourcePolicy {
    private final FluxSinkSupplier<CoreEvent> policySink;

    CommonSourcePolicy(Supplier<FluxSink<CoreEvent>> sinkFactory) {
        this.policySink = new TransactionAwareFluxSinkSupplier<CoreEvent>(sinkFactory, new RoundRobinFluxSinkSupplier(Runtime.getRuntime().availableProcessors(), sinkFactory));
    }

    public void process(SourcePolicy sourcePolicy, CoreEvent sourceEvent, MessageSourceResponseParametersProcessor respParamProcessor, CompletableCallback<Either<SourcePolicyFailureResult, SourcePolicySuccessResult>> callback) {
        SourcePolicyContext ctx = SourcePolicyContext.from(sourceEvent);
        if (ctx != null) {
            ctx.configure(respParamProcessor, callback);
            ctx.setPinnedSourcePolicy(sourcePolicy);
        }
        ((FluxSink)this.policySink.get()).next((Object)sourceEvent);
    }

    public void finishFlowProcessing(CoreEvent event, Either<SourcePolicyFailureResult, SourcePolicySuccessResult> result) {
        if (!((BaseEventContext)event.getContext()).isComplete()) {
            ((BaseEventContext)event.getContext()).success(event);
        }
        SourcePolicyContext.from(event).getProcessCallback().complete(result);
    }

    public void finishFlowProcessing(CoreEvent event, Either<SourcePolicyFailureResult, SourcePolicySuccessResult> result, Throwable error, SourcePolicyContext ctx) {
        if (!((BaseEventContext)event.getContext()).isComplete()) {
            ((BaseEventContext)event.getContext()).error(error);
        }
        ctx.getProcessCallback().complete(result);
    }

    public void dispose() {
        this.policySink.dispose();
    }

    public Disposable deferredDispose() {
        FluxSinkSupplier<CoreEvent> sink = this.policySink;
        return () -> sink.dispose();
    }
}

