/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.config.bootstrap;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.config.bootstrap.BootstrapException;
import org.mule.runtime.core.api.config.bootstrap.RegistryBootstrapDiscoverer;
import org.mule.runtime.core.internal.util.PropertiesUtils;

public class ClassLoaderRegistryBootstrapDiscoverer
implements RegistryBootstrapDiscoverer {
    private final ClassLoader classLoader;

    public ClassLoaderRegistryBootstrapDiscoverer(ClassLoader classLoader) {
        Preconditions.checkArgument((classLoader != null ? 1 : 0) != 0, (String)"Classloader cannot be null");
        this.classLoader = classLoader;
    }

    @Override
    public List<Properties> discover() throws BootstrapException {
        try {
            return PropertiesUtils.discoverProperties(this.classLoader, "META-INF/org/mule/runtime/core/config/registry-bootstrap.properties");
        }
        catch (IOException e) {
            throw new BootstrapException(I18nMessageFactory.createStaticMessage((String)"Could not load properties file"), e);
        }
    }
}

