/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.alert;

import jakarta.inject.Inject;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.runtime.api.alert.AlertingSupport;
import org.mule.runtime.api.alert.TimedDataAggregation;
import org.mule.runtime.api.alert.TimedDataBuffer;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.time.TimeSupplier;
import org.mule.runtime.core.api.alert.MuleAlertingSupport;
import org.mule.runtime.core.internal.artifact.ArtifactClassLoaderFinder;
import org.mule.runtime.metrics.api.exporters.ExporterMetrics;
import org.mule.runtime.module.log4j.api.MuleAlertingAsyncQueueFullPolicy;

public class DefaultAlertingSupport
implements MuleAlertingSupport,
Initialisable {
    private static final Map<ClassLoader, AlertingSupport> ALERTING_SUPPORT_PER_DEPLOYMENT = new WeakHashMap<ClassLoader, AlertingSupport>();
    private TimeSupplier timeSupplier;
    private final Map<String, TimedDataBuffer> timedBuffersPerAlert = new ConcurrentHashMap<String, TimedDataBuffer>();
    private final Map<String, Map<String, TimedDataBuffer<Object>>> contextsPerAlert = new ConcurrentHashMap<String, Map<String, TimedDataBuffer<Object>>>();
    private static final String LOGGING_MODULE_NAME = "org.mule.runtime.logging";
    private static final String MULE_ALERTING_ASYNC_QUEUE_FULL_POLICY_CLASS = "org.mule.runtime.module.log4j.api.MuleAlertingAsyncQueueFullPolicy";
    private static final String METRICS_API_MODULE_NAME = "org.mule.runtime.metrics.api";
    private static final String MULE_EXPORTER_METRICS_CLASS = "org.mule.runtime.metrics.api.exporters.ExporterMetrics";

    public void initialise() throws InitialisationException {
        this.configureLog4jQueueFullAlert();
        this.configureOpenTelemetryExportQueueFullAlert();
    }

    public void triggerAlert(String alertName) {
        this.triggerAlert(alertName, null);
    }

    public <T> void triggerAlert(String alertName, T alertData) {
        TimedDataBuffer buffer = this.timedBuffersPerAlert.computeIfAbsent(Objects.requireNonNull(alertName, "'alertName' cannot be null"), k -> new TimedDataBuffer(this.timeSupplier));
        buffer.put(alertData);
        if (alertData != null) {
            Map alertContexts = this.contextsPerAlert.computeIfAbsent(alertName, k -> new ConcurrentHashMap());
            String normalizedContext = this.normalizeContext(alertData);
            TimedDataBuffer contextBuffer = alertContexts.computeIfAbsent(normalizedContext, k -> new TimedDataBuffer(this.timeSupplier));
            contextBuffer.put((Object)normalizedContext);
        }
    }

    @Override
    public Map<String, TimedDataAggregation<Integer>> alertsCountAggregation() {
        return this.alertsAggregation(() -> 0, (a, t) -> a + 1);
    }

    @Override
    public Map<String, Map<String, Integer>> getAlertContexts() {
        ConcurrentHashMap result = new ConcurrentHashMap();
        this.contextsPerAlert.forEach((alertName, alertContexts) -> {
            ConcurrentHashMap contextCounts = new ConcurrentHashMap();
            alertContexts.forEach((contextString, contextBuffer) -> {
                int contextCount = contextBuffer.size();
                if (contextCount > 0) {
                    contextCounts.put(contextString, contextCount);
                }
            });
            if (!contextCounts.isEmpty()) {
                result.put(alertName, contextCounts);
            }
        });
        return Collections.unmodifiableMap(result);
    }

    @Override
    public <A> Map<String, TimedDataAggregation<A>> alertsAggregation(Supplier<A> baseIntervalAggregationSupplier, BiFunction<A, Object, A> accumulator) {
        Object baseIntevalAggregation = baseIntervalAggregationSupplier.get();
        this.evictEmptyBuffers();
        return this.timedBuffersPerAlert.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((TimedDataBuffer)e.getValue()).aggregate(baseIntevalAggregation, accumulator), (x, y) -> x, TreeMap::new));
    }

    @Inject
    public void setTimeSupplier(TimeSupplier timeSupplier) {
        this.timeSupplier = timeSupplier;
    }

    private void configureLog4jQueueFullAlert() {
        if (this.isMuleAlertingAsyncQueueFullPolicy()) {
            ClassLoader regionContextClassLoader = this.registerForCallbacks();
            MuleAlertingAsyncQueueFullPolicy.registerLog4jQueueFullCallback((ClassLoader)regionContextClassLoader, regionClassLoader -> ALERTING_SUPPORT_PER_DEPLOYMENT.get(regionClassLoader).triggerAlert("ASYNC_LOGGER_RINGBUFFER_FULL"));
        }
    }

    private void configureOpenTelemetryExportQueueFullAlert() {
        if (this.isMuleExporterMetricsPresent()) {
            ClassLoader regionContextClassLoader = this.registerForCallbacks();
            ExporterMetrics.registerQueueFullCallback((ClassLoader)regionContextClassLoader, (regionClassLoader, alertData) -> ALERTING_SUPPORT_PER_DEPLOYMENT.get(regionClassLoader).triggerAlert("OTEL_EXPORT_QUEUE_FULL", alertData));
        }
    }

    private ClassLoader registerForCallbacks() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        ClassLoader regionContextClassLoader = ArtifactClassLoaderFinder.artifactClassLoaderFinder().findRegionContextClassLoader().orElse(tccl);
        ALERTING_SUPPORT_PER_DEPLOYMENT.put(regionContextClassLoader, this);
        return regionContextClassLoader;
    }

    private boolean isMuleExporterMetricsPresent() {
        return this.isPresent(METRICS_API_MODULE_NAME, MULE_EXPORTER_METRICS_CLASS);
    }

    private boolean isMuleAlertingAsyncQueueFullPolicy() {
        return this.isPresent(LOGGING_MODULE_NAME, MULE_ALERTING_ASYNC_QUEUE_FULL_POLICY_CLASS);
    }

    private boolean isPresent(String moduleName, String fullClassName) {
        ModuleLayer callerLayer = this.getClass().getModule().getLayer();
        if (callerLayer != null) {
            return callerLayer.findModule(moduleName).isPresent();
        }
        return this.canLoadClass(fullClassName);
    }

    private boolean canLoadClass(String fullClassName) {
        try {
            this.getClass().getClassLoader().loadClass(fullClassName);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void evictEmptyBuffers() {
        this.timedBuffersPerAlert.entrySet().removeIf(entry -> {
            String alertName = (String)entry.getKey();
            TimedDataBuffer buffer = (TimedDataBuffer)entry.getValue();
            if (buffer.size() == 0) {
                this.contextsPerAlert.remove(alertName);
                return true;
            }
            return false;
        });
    }

    private String normalizeContext(Object context) {
        String contextStr = context.toString();
        String normalized = contextStr.replaceAll("@[0-9a-fA-F]+", "");
        normalized = normalized.replaceAll("\\s+", " ").trim();
        return normalized;
    }
}

