/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.utils;

import com.github.zafarkhaja.semver.ParseException;
import com.github.zafarkhaja.semver.Version;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.core.resources.IProject;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.deployer.PackagingRequest;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.maven.cmdline.MavenCommandLine;
import org.mule.tooling.maven.extension.Extension;
import org.mule.tooling.maven.extension.Extensions;

public class MavenUtils {
    public static final String ERROR_WRITTING_EXTENSIONS_FILE = "There was a problem while trying to write .extensions file";
    public static final String DEFAULT_CMDLINE = "mvn clean package";
    public static final String POM_FILENAME = "pom.xml";

    public static boolean isMavenBased(IProject project) {
        if (project == null) {
            throw new IllegalArgumentException("project == null");
        }
        return project.getFile(POM_FILENAME).exists();
    }

    public static boolean isMavenBased(IMuleProject project) {
        if (project == null) {
            throw new IllegalArgumentException("project == null");
        }
        return project.getFile(POM_FILENAME).exists();
    }

    public static Model getPomModel(File pomFile) {
        MavenXpp3Reader mavenXpp3Reader = new MavenXpp3Reader();
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileInputStream is = new FileInputStream(pomFile);){
                Model model = mavenXpp3Reader.read((InputStream)is);
                model.setPomFile(pomFile);
                return model;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Optional<Extensions> getExtensionsModel(File extensionsFile) {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (FileInputStream is = new FileInputStream(extensionsFile);){
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Extensions.class});
                Unmarshaller jaxbMarshaller = jaxbContext.createUnmarshaller();
                return Optional.ofNullable((Extensions)jaxbMarshaller.unmarshal((InputStream)is));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JAXBException | IOException throwable) {
            return Optional.empty();
        }
    }

    public static boolean writeExtensionsToFile(File extensionsFile, Extensions mavenExtensionModel) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Extensions.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal((Object)mavenExtensionModel, extensionsFile);
            return true;
        }
        catch (JAXBException e) {
            MuleCorePlugin.logError((String)ERROR_WRITTING_EXTENSIONS_FILE, (Throwable)e);
            return false;
        }
    }

    public static boolean updateOrCreateExtension(File extensionsFile, Extension extensionToUpdate) {
        Extensions extensionsModel = MavenUtils.getExtensionsModel(extensionsFile).orElse(new Extensions());
        Optional<Extension> foundExtension = extensionsModel.getExtensions().stream().filter(extension2 -> MavenUtils.isSameGA(extension2, extensionToUpdate)).findFirst();
        if (foundExtension.isPresent()) {
            foundExtension.get().setVersion(extensionToUpdate.getVersion().orElse(null));
        } else {
            extensionsModel.getExtensions().add(extensionToUpdate);
        }
        return MavenUtils.writeExtensionsToFile(extensionsFile, extensionsModel);
    }

    private static boolean isSameGA(Extension extension, Extension extensionToUpdate) {
        return extension.getArtifactId().equals(extensionToUpdate.getArtifactId()) && extension.getGroupId().equals(extensionToUpdate.getGroupId());
    }

    public static MavenCommandLine getCommandLine(String baseCommand, PackagingRequest packagingRequest) {
        StringBuilder commandLineBuilder = new StringBuilder(baseCommand);
        if (packagingRequest.attachSources()) {
            commandLineBuilder.append(" -DattachMuleSources=true");
        }
        packagingRequest.getOption("export.test_jar").ifPresent(x -> {
            StringBuilder stringBuilder2 = commandLineBuilder.append(" -DtestJar");
        });
        packagingRequest.getOption("maven.export.offline").ifPresent(x -> {
            StringBuilder stringBuilder2 = commandLineBuilder.append(" -o");
        });
        packagingRequest.getOption("maven.export.skip_validation").ifPresent(x -> {
            StringBuilder stringBuilder2 = commandLineBuilder.append(" -DskipValidation");
        });
        packagingRequest.getOption("maven.export.skip_munit_test").ifPresent(x -> {
            StringBuilder stringBuilder2 = commandLineBuilder.append(" -DskipMunitTests");
        });
        packagingRequest.getOption("maven.export.skip_all_tests").ifPresent(x -> {
            StringBuilder stringBuilder2 = commandLineBuilder.append(" -DskipTests");
        });
        packagingRequest.getOption("maven.export.skip_ast").ifPresent(x -> {
            StringBuilder stringBuilder2 = commandLineBuilder.append(" -DskipAST");
        });
        if (packagingRequest.isLightweight()) {
            commandLineBuilder.append(" -DlightweightPackage");
        }
        if (packagingRequest.useLocalRepo()) {
            commandLineBuilder.append(" -DuseLocalRepository");
        }
        if (packagingRequest.onlySources()) {
            commandLineBuilder.append(" -DonlyMuleSources=true");
            commandLineBuilder.append(" -f .org.mule.tooling.pom");
            commandLineBuilder.append(" -DskipAST");
        }
        packagingRequest.getOption("maven.export.snapshots_update").ifPresent(updateValue -> {
            Boolean update = (Boolean)updateValue;
            if (update.booleanValue()) {
                commandLineBuilder.append(" -U");
            } else {
                commandLineBuilder.append(" -nsu");
            }
        });
        if (!baseCommand.contains("maven.repo.local") && !StringUtils.isEmpty((String)MavenCore.getM2repoPath())) {
            commandLineBuilder.append(" \"-Dmaven.repo.local=").append(MavenCore.getM2repoPath()).append("\"");
        }
        return MavenCommandLine.fromString(commandLineBuilder.toString());
    }

    public static String getGavString(MavenDependency dependency) {
        return org.mule.tooling.core.m2.utils.MavenUtils.getGavString((MavenDependency)dependency);
    }

    public static boolean isValidSemanticVersion(String version) {
        try {
            Version.valueOf((String)version);
        }
        catch (ParseException | IllegalArgumentException throwable) {
            return false;
        }
        return true;
    }

    public static Version getVersion(String version) {
        Version currentVersion = null;
        try {
            currentVersion = Version.valueOf((String)version);
        }
        catch (ParseException | IllegalArgumentException throwable) {}
        return currentVersion;
    }

    public static Integer getMajorVersion(String version) {
        try {
            return Version.valueOf((String)version).getMajorVersion();
        }
        catch (ParseException | IllegalArgumentException throwable) {
            return null;
        }
    }

    public static String getReleaseVersion(String version) {
        try {
            return Version.valueOf((String)version).getNormalVersion();
        }
        catch (ParseException | IllegalArgumentException e) {
            MuleCorePlugin.logError((String)("Error trying to parse version " + version), (Throwable)e);
            return null;
        }
    }

    public static String formatToValidVersion(String version) {
        String releaseVersion = MavenUtils.getReleaseVersion(version);
        if (releaseVersion != null) {
            return releaseVersion;
        }
        return version;
    }

    public static Optional<String> increaseMajorVersion(String version) {
        Optional<String> newVersion = Optional.empty();
        try {
            Version mavenVersion = Version.valueOf((String)version);
            newVersion = Optional.of(mavenVersion.incrementMajorVersion().toString());
        }
        catch (ParseException | IllegalArgumentException throwable) {}
        return newVersion;
    }

    public static Optional<String> increasePatchVersion(String version) {
        Optional<String> newVersion = Optional.empty();
        try {
            Version mavenVersion = Version.valueOf((String)version);
            newVersion = Optional.of(mavenVersion.incrementPatchVersion().toString());
        }
        catch (ParseException | IllegalArgumentException throwable) {}
        return newVersion;
    }
}

