/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import org.eclipse.core.runtime.IProgressMonitor;

public class MavenOutputToMonitorRedirectorThread
extends Thread {
    static final int PROGRESS_STEP = 1;
    static final int PROGRESS_UPPER_LIMIT = 200;
    private final IProgressMonitor monitor;
    private final PipedInputStream sourceStream;
    private String taskName;
    private OutputStream nextOutputStream;
    private int progressUpperLimit = 200;

    public MavenOutputToMonitorRedirectorThread(PipedInputStream sourceStream, IProgressMonitor monitor, String taskName, OutputStream nextOutputStream) {
        super("MavenOutputToMonitorRedirectorThread");
        this.monitor = monitor;
        this.sourceStream = sourceStream;
        this.taskName = taskName;
        this.nextOutputStream = nextOutputStream;
    }

    public MavenOutputToMonitorRedirectorThread(PipedInputStream sourceStream, IProgressMonitor monitor, String taskName) {
        this(sourceStream, monitor, taskName, new PipedOutputStream());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.monitor.beginTask(this.taskName, 200);
        this.monitor.setTaskName(this.taskName);
        try {
            try {
                Throwable throwable = null;
                Object var2_3 = null;
                try {
                    InputStreamReader inputStreamReader = new InputStreamReader(this.sourceStream);
                    try {
                        try (BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                            String line;
                            PrintWriter outputWriter = null;
                            if (this.nextOutputStream != null) {
                                outputWriter = new PrintWriter(this.nextOutputStream);
                            }
                            int worked = 0;
                            while (!this.isInterrupted() && (line = bufferedReader.readLine()) != null) {
                                if (outputWriter != null) {
                                    outputWriter.println(line);
                                    outputWriter.flush();
                                }
                                if (line.isEmpty()) continue;
                                this.monitor.subTask(line);
                                if (worked >= this.progressUpperLimit - 1) continue;
                                this.monitor.worked(1);
                                ++worked;
                            }
                        }
                        if (inputStreamReader == null) return;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (inputStreamReader == null) throw throwable;
                        inputStreamReader.close();
                        throw throwable;
                    }
                    inputStreamReader.close();
                    return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                if (this.isInterrupted() || this.monitor.isCanceled()) return;
                this.monitor.setTaskName("");
                this.monitor.done();
            }
            return;
        }
        finally {
            if (!this.isInterrupted() && !this.monitor.isCanceled()) {
                this.monitor.setTaskName("");
                this.monitor.done();
            }
        }
    }

    public void setProgressUpperLimit(int progressUpperLimit) {
        this.progressUpperLimit = progressUpperLimit;
    }
}

