/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.utils;

import java.util.Optional;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.m2.plugin.MavenBuildPlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.maven.MavenMuleProjectDecorator;
import org.mule.tooling.maven.utils.MavenCompilerConfigurer;

public class MavenCompilerPluginUtils {
    private static final String JAVA_MODULE_GA = "org.mule.module:mule-java-module:";

    public static void checkAndUpdateJavaCompilationTarget(IMuleProject muleProject) {
        muleProject.getModuleManager(EditingScope.APP).getExternalModules().stream().filter(module -> module.getId().startsWith(JAVA_MODULE_GA)).findAny().ifPresent(module -> new MavenCompilerConfigurer(muleProject).configureMavenCompilerIfAbsent());
    }

    public static Optional<MavenBuildPlugin.Configuration> getJavaCompilerPluginTarget(MavenMuleProjectDecorator projectDecorator) {
        return MavenCompilerPluginUtils.getPluginConfiguration(projectDecorator).flatMap(config -> config.getChild("target"));
    }

    public static boolean containsJavaCompilerPlugin(MavenMuleProjectDecorator mavenMuleProject) {
        return mavenMuleProject.hasPlugin("org.apache.maven.plugins", "maven-compiler-plugin");
    }

    public static Optional<MavenBuildPlugin.Configuration> getPluginConfiguration(MavenMuleProjectDecorator mavenMuleProject) {
        return mavenMuleProject.getPlugin("org.apache.maven.plugins", "maven-compiler-plugin").flatMap(plugin -> plugin.getConfiguration());
    }

    public static Optional<MavenBuildPlugin.Configuration> getPluginConfigurationCompilerArgs(MavenMuleProjectDecorator mavenMuleProject) {
        return MavenCompilerPluginUtils.getPluginConfiguration(mavenMuleProject).flatMap(config -> config.getChild("compilerArgs"));
    }

    public static Optional<MavenBuildPlugin.Configuration> getPluginConfigurationCompilerArgsArgs(MavenMuleProjectDecorator mavenMuleProject) {
        return MavenCompilerPluginUtils.getPluginConfigurationCompilerArgs(mavenMuleProject).flatMap(compilerArgs -> compilerArgs.getChild("args"));
    }
}

