/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.utils;

import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.mule.tooling.core.m2.plugin.MavenBuildPlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.maven.MavenMuleProjectDecorator;
import org.mule.tooling.maven.MavenPlugin;
import org.mule.tooling.maven.utils.MavenCompilerPluginUtils;

public class MavenCompilerConfigurer {
    private static final String ERROR_MSG_TARGET_BELOW_1_8 = "Compiler target below to 1.8 could generate runtime errors while get class information";
    public static final String MAVEN_COMPILER_TARGET_PROPERTY = "maven.compiler.target";
    public static final String APACHE_MAVEN_PLUGINS_GROUP_ID = "org.apache.maven.plugins";
    public static final String MAVEN_COMPILER_ARTIFACT_ID = "maven-compiler-plugin";
    public static final String MAVEN_COMPILER_VERSION = "3.10.1";
    public static final String CONFIGURATION = "configuration";
    public static final String COMPILER_ARGS = "compilerArgs";
    public static final String ARGS = "args";
    public static final String STORE_PARAMETERS_NAMES_ARG = "-parameters";
    public static final String TARGET = "target";
    private final MavenMuleProjectDecorator mavenMuleProject;

    public MavenCompilerConfigurer(IMuleProject muleProject) {
        this.mavenMuleProject = MavenMuleProjectDecorator.decorate(muleProject);
    }

    public void configureMavenCompilerIfAbsent() {
        this.configureAnyBasePluginPartIfAbsent();
        Optional<String> targetPropertyOpt = Optional.ofNullable(this.mavenMuleProject.getProperties().get(MAVEN_COMPILER_TARGET_PROPERTY));
        Optional<String> targetInPluginOpt = MavenCompilerPluginUtils.getJavaCompilerPluginTarget(this.mavenMuleProject).map(MavenBuildPlugin.Configuration::getValue);
        if (targetPropertyOpt.isPresent() || targetInPluginOpt.isPresent()) {
            Stream.of(targetPropertyOpt, targetInPluginOpt).filter(Optional::isPresent).map(Optional::get).filter(target -> JavaCore.compareJavaVersions((String)target, (String)"1.8") < 0).findAny().ifPresent(target -> MavenPlugin.logWarning(ERROR_MSG_TARGET_BELOW_1_8));
            return;
        }
        this.mavenMuleProject.editPluginConfiguration(APACHE_MAVEN_PLUGINS_GROUP_ID, MAVEN_COMPILER_ARTIFACT_ID, xmlEditorHelper -> {
            xmlEditorHelper.createElement(TARGET).setValue("1.8");
            return true;
        });
    }

    private void configureAnyBasePluginPartIfAbsent() {
        if (!MavenCompilerPluginUtils.containsJavaCompilerPlugin(this.mavenMuleProject)) {
            this.mavenMuleProject.addPlugin(APACHE_MAVEN_PLUGINS_GROUP_ID, MAVEN_COMPILER_ARTIFACT_ID, MAVEN_COMPILER_VERSION, saveEdition -> true);
        }
        if (!MavenCompilerPluginUtils.getPluginConfiguration(this.mavenMuleProject).isPresent()) {
            this.mavenMuleProject.editPluginConfiguration(APACHE_MAVEN_PLUGINS_GROUP_ID, MAVEN_COMPILER_ARTIFACT_ID, saveEdition -> true);
        }
        if (!MavenCompilerPluginUtils.getPluginConfigurationCompilerArgs(this.mavenMuleProject).isPresent()) {
            this.mavenMuleProject.editPluginConfiguration(APACHE_MAVEN_PLUGINS_GROUP_ID, MAVEN_COMPILER_ARTIFACT_ID, edition -> {
                edition.createElement(COMPILER_ARGS);
                return true;
            });
        }
        if (!MavenCompilerPluginUtils.getPluginConfigurationCompilerArgsArgs(this.mavenMuleProject).isPresent()) {
            this.mavenMuleProject.editPluginConfiguration(APACHE_MAVEN_PLUGINS_GROUP_ID, MAVEN_COMPILER_ARTIFACT_ID, edition -> {
                edition.getOrCreateElement(COMPILER_ARGS).createElement(ARGS).setValue(STORE_PARAMETERS_NAMES_ARG);
                return true;
            });
        }
    }

    private String getTarget() {
        String minimumTarget = "1.8";
        try {
            IJavaProject javaProject = this.mavenMuleProject.getMuleProject().getJavaProject();
            String compliance = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
            if (compliance != null) {
                return compliance;
            }
            IVMInstall vm = JavaRuntime.getVMInstall((IJavaProject)javaProject);
            if (!(vm instanceof IVMInstall2)) {
                return minimumTarget;
            }
            String javaVersion = ((IVMInstall2)vm).getJavaVersion();
            if (javaVersion == null) {
                return minimumTarget;
            }
            String major = javaVersion.substring(0, javaVersion.indexOf(46));
            if ("1".equals(major)) {
                return minimumTarget;
            }
            return major;
        }
        catch (CoreException coreException) {
            return minimumTarget;
        }
    }
}

