/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.source;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.mule.tooling.core.m2.MavenResourceUtils;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.dependency.PojoMavenDependencyBuilder;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.runtime.sources.SourceAttachmentProvider;
import org.mule.tooling.core.runtime.sources.internal.DependencyCache;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.maven.MavenPlugin;
import org.mule.tooling.osgi.services.ServicesRegistry;
import org.mule.tooling.osgi.services.maven.MavenJarFileInspector;
import org.mule.tooling.osgi.services.maven.MavenJarFileInspectorService;

public class MavenSourceAttachmentProvider
implements SourceAttachmentProvider {
    private static final String CLASSIFIER_SOURCE = "sources";
    private MavenJarFileInspectorService mavenJarInspectorService;

    public com.google.common.base.Optional<IPath> getSourceAttachment(IPath filePath, IServerDefinition serverDefinition) {
        MavenJarFileInspectorService mavenInspectorService = this.getMavenInspectorService();
        IPath m2RepoPath = Path.fromOSString((String)MavenCore.getM2repoPath());
        if (this.exists(m2RepoPath) && this.isJar(filePath)) {
            return this.doGetSourceAttachment(filePath, mavenInspectorService, m2RepoPath);
        }
        return com.google.common.base.Optional.absent();
    }

    private boolean isJar(IPath filePath) {
        return filePath.toOSString().endsWith(".jar");
    }

    private boolean exists(IPath m2RepoPath) {
        return !m2RepoPath.isEmpty() && m2RepoPath.toFile().exists();
    }

    private com.google.common.base.Optional<IPath> doGetSourceAttachment(IPath filePath, MavenJarFileInspectorService mavenInspectorService, IPath m2RepoPath) {
        Optional maybeDependency = DependencyCache.getOrComputeMavenDependency((IPath)filePath, keyPath -> {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (JarFile jarFile = new JarFile(keyPath.toFile());){
                    MavenJarFileInspector inspector = mavenInspectorService.getInspector(jarFile);
                    return ((PojoMavenDependencyBuilder)PojoMavenDependencyBuilder.newInstance().withGroupId(inspector.getGroupId())).build();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                MavenPlugin.logError("There was a problem reading maven metadata from file " + filePath.toOSString(), e);
                return null;
            }
        });
        if (maybeDependency.isPresent()) {
            MavenDependency dep = (MavenDependency)maybeDependency.get();
            if (CoreUtils.areNotBlank((String[])new String[]{dep.getGroupId(), dep.getArtifactId(), dep.getVersion()})) {
                return this.getPathToDependencyIfExisting(m2RepoPath, dep.getGroupId(), dep.getArtifactId(), dep.getArtifactId());
            }
        }
        return com.google.common.base.Optional.absent();
    }

    private com.google.common.base.Optional<IPath> getPathToDependencyIfExisting(IPath m2RepoPath, String groupId, String artifactId, String version) {
        String repositoryPath = MavenResourceUtils.getRepositoryPath((String)groupId, (String)artifactId, (String)version, Optional.of(CLASSIFIER_SOURCE), Optional.empty(), (String)File.separator);
        IPath dependencyPath = m2RepoPath.append(repositoryPath);
        if (dependencyPath.toFile().exists()) {
            return com.google.common.base.Optional.of((Object)dependencyPath);
        }
        return com.google.common.base.Optional.absent();
    }

    private MavenJarFileInspectorService getMavenInspectorService() {
        if (this.mavenJarInspectorService == null) {
            this.mavenJarInspectorService = ServicesRegistry.get().getMavenJarInspectorService();
            if (this.mavenJarInspectorService == null) {
                throw new RuntimeException("A maven jar file inspector service should be registered, since we are in the maven plugin");
            }
        }
        return this.mavenJarInspectorService;
    }
}

