/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.runner;

import java.io.File;
import java.io.OutputStream;
import org.eclipse.core.resources.IProject;
import org.mule.tooling.maven.MavenPlugin;
import org.mule.tooling.maven.cmdline.MavenCommandLine;
import org.mule.tooling.maven.runner.MavenExecutionException;
import org.mule.tooling.maven.runner.MavenRunner;
import org.mule.tooling.maven.runner.MavenRunnerCallback;

public class TrackingMavenRunner
implements MavenRunner {
    private final MavenRunner mavenRunner;

    public TrackingMavenRunner(MavenRunner mavenRunner) {
        this.mavenRunner = mavenRunner;
    }

    @Override
    public void run(File pomFile, MavenCommandLine commandLine, MavenRunnerCallback callback, OutputStream outputStream) throws MavenExecutionException {
        this.mavenRunner.run(pomFile, commandLine, (MavenRunnerCallback)new TrackingCallback(this.mavenRunner, callback, System.currentTimeMillis()), outputStream);
    }

    @Override
    public void cancelBuild() {
        this.mavenRunner.cancelBuild();
    }

    @Override
    public void runBare(MavenCommandLine commandLine, MavenRunnerCallback callback, OutputStream outputStream) {
        this.mavenRunner.runBare(commandLine, new TrackingCallback(this.mavenRunner, callback, System.currentTimeMillis()), outputStream);
    }

    @Override
    public void run(IProject project, MavenCommandLine commandLine, MavenRunnerCallback callback, OutputStream outputStream) throws MavenExecutionException {
        this.mavenRunner.run(project, commandLine, (MavenRunnerCallback)new TrackingCallback(this.mavenRunner, callback, System.currentTimeMillis()), outputStream);
    }

    private static class TrackingCallback
    implements MavenRunnerCallback {
        private final long ini;
        private final MavenRunner runner;
        private final MavenRunnerCallback callback;

        public TrackingCallback(MavenRunner runner, MavenRunnerCallback callback, long ini) {
            this.runner = runner;
            this.callback = callback;
            this.ini = ini;
        }

        @Override
        public void finished(int result) {
            this.track(this.ini);
            this.callback.finished(result);
        }

        private void track(long ini) {
            if (MavenPlugin.trackBuildTimes()) {
                MavenPlugin.logInfo(" *** " + (System.currentTimeMillis() - ini) + " " + String.valueOf(this.runner));
            }
        }
    }
}

