/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.runner;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.mule.tooling.maven.runner.MavenRunnerCallback;

public class SyncGetResultCallback
implements MavenRunnerCallback {
    public static final int STILL_NOT_FINISHED = -1073741824;
    private Semaphore semaphore = new Semaphore(0);
    private int result;
    private boolean finished = false;

    @Override
    public void finished(int result) {
        this.finished = true;
        this.result = result;
        this.semaphore.release();
    }

    public int getResult() throws InterruptedException {
        this.semaphore.acquire();
        return this.result;
    }

    public int getResult(long timeout) throws InterruptedException {
        this.semaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS);
        if (this.finished) {
            return this.result;
        }
        return -1073741824;
    }
}

