/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.runner;

import java.util.List;
import java.util.stream.Collectors;
import org.mule.tooling.maven.runner.ExtensibleCommandLineRunnerFactory;
import org.mule.tooling.maven.runner.MavenRunnerFactory;
import org.mule.tooling.maven.runner.TrackingMavenRunnerFactory;
import org.mule.tooling.utils.extensionpoint.ExtensionAttribute;
import org.mule.tooling.utils.extensionpoint.ExtensionPoint;
import org.mule.tooling.utils.extensionpoint.IExtensionPointReader;

@ExtensionPoint(extensionPointId="org.mule.tooling.maven.runnerfactory")
public class MavenRunnerFactoryExtension {
    @ExtensionAttribute
    private MavenRunnerFactory factory;

    public MavenRunnerFactory getFactory() {
        return this.factory;
    }

    public void setFactory(MavenRunnerFactory factory) {
        this.factory = factory;
    }

    public static List<MavenRunnerFactory> getFactories() {
        return Singleton.factories;
    }

    private static class Singleton {
        private static final List<MavenRunnerFactory> factories = Singleton.getFactories();

        private Singleton() {
        }

        private static List<MavenRunnerFactory> getFactories() {
            return IExtensionPointReader.create(MavenRunnerFactoryExtension.class).readAll().stream().map(ext -> new TrackingMavenRunnerFactory(ext.getFactory())).map(ExtensibleCommandLineRunnerFactory::new).collect(Collectors.toList());
        }
    }
}

