/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.runner;

import java.util.List;
import java.util.Optional;
import org.mule.tooling.maven.runner.MavenRunner;
import org.mule.tooling.maven.runner.MavenRunnerConfiguration;
import org.mule.tooling.maven.runner.MavenRunnerFactory;
import org.mule.tooling.maven.runner.MavenRunnerFactoryExtension;

public class MavenRunnerBuilder {
    private MavenRunnerConfiguration configuration;
    private String javaHomePath;

    private MavenRunnerBuilder(MavenRunnerConfiguration configuration) {
        this.configuration = configuration;
    }

    public static MavenRunnerBuilder with(MavenRunnerConfiguration configuration) {
        return new MavenRunnerBuilder(configuration);
    }

    public MavenRunnerBuilder setJavaHome(String path) {
        this.javaHomePath = path;
        return this;
    }

    public MavenRunner build() {
        List<MavenRunnerFactory> factories = MavenRunnerFactoryExtension.getFactories();
        Optional<Object> runner = Optional.empty();
        Optional<String> javaHomeOpt = Optional.ofNullable(this.javaHomePath);
        for (MavenRunnerFactory factory : factories) {
            if (runner.isPresent()) continue;
            runner = factory.create(this.configuration, javaHomeOpt);
        }
        return (MavenRunner)runner.orElseThrow(() -> new IllegalArgumentException("No maven runner found for configuration: " + String.valueOf(this.configuration)));
    }
}

