/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.runner;

import java.io.File;
import java.util.List;
import java.util.StringTokenizer;
import org.mule.tooling.maven.runner.UnixMavenBinarySearcher;
import org.mule.tooling.maven.runner.WindowsMavenBinarySearcher;

public abstract class MavenBinarySearcher {
    public static MavenBinarySearcher newInstance() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            return new WindowsMavenBinarySearcher();
        }
        if (osName.startsWith("Linux")) {
            return new UnixMavenBinarySearcher();
        }
        if (osName.startsWith("Mac")) {
            return new UnixMavenBinarySearcher();
        }
        return null;
    }

    public abstract String search();

    public File search(File basePath) {
        List<String> mavenBinaryFilenames = this.getMavenBinaryFilenames();
        for (String mavenBinaryFileName : mavenBinaryFilenames) {
            File file = new File(basePath, mavenBinaryFileName);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    protected String searchInSystemPath(String pathVariableName, List<String> mvnExecutableFileNames) {
        String pathVariable = System.getenv(pathVariableName);
        StringTokenizer tokenizer = new StringTokenizer(pathVariable, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String basePath = tokenizer.nextToken();
            for (String mvnExecutableFileName : mvnExecutableFileNames) {
                File potentialMvnFile = new File(basePath, mvnExecutableFileName);
                if (!potentialMvnFile.exists()) continue;
                return new File(basePath).getParent();
            }
        }
        return null;
    }

    public abstract List<String> getMavenBinaryFilenames();
}

