/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.query.internal.central;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.mule.tooling.core.utils.CoreUtils;

public class MavenCentralResponse {
    public static final String GROUP_ID = "key_groupId";
    public static final String ARTIFACT_ID = "key_artifactId";
    public static final String LATEST_VERSION = "key_latestver";
    private Gson gson = new Gson();
    private boolean successful;
    private int totalHitCount;
    private List<Map<String, String>> artifacts;
    private String failureMessage;

    public MavenCentralResponse(Response clientResponse) {
        int status = clientResponse.getStatus();
        String body = (String)clientResponse.readEntity(String.class);
        switch (status) {
            case 200: {
                this.parse(body);
                break;
            }
            default: {
                this.successful = false;
                this.failureMessage = body;
            }
        }
    }

    private void parse(String jsonContent) {
        Map jsonMap = (Map)this.gson.fromJson(jsonContent, Map.class);
        this.successful = this.getStatus(jsonMap);
        if (this.successful) {
            this.totalHitCount = this.getTotalHitCount(jsonMap);
            this.artifacts = this.getArtifacts(jsonMap);
        } else {
            this.failureMessage = jsonContent;
        }
    }

    private List<Map<String, String>> getArtifacts(Map<String, Object> jsonMap) {
        List docs = (List)this.getResponse(jsonMap).get("docs");
        ArrayList<Map<String, String>> artifacts = new ArrayList<Map<String, String>>(docs.size());
        for (Map docsElement : docs) {
            HashMap<String, String> artifact = this.getArtifact(docsElement);
            if (artifact == null) continue;
            artifacts.add(artifact);
        }
        return artifacts;
    }

    private HashMap<String, String> getArtifact(Map<String, Object> docsElement) {
        HashMap<String, String> artifact = null;
        String groupId = this.getGroupId(docsElement);
        String artifactId = this.getArtifactId(docsElement);
        String version = this.getVersion(docsElement);
        if (CoreUtils.areNotBlank((String[])new String[]{groupId, artifactId, version})) {
            artifact = new HashMap<String, String>(3);
            artifact.put(GROUP_ID, groupId);
            artifact.put(ARTIFACT_ID, artifactId);
            artifact.put(LATEST_VERSION, version);
        }
        return artifact;
    }

    private String getVersion(Map<String, Object> docsElement) {
        Object latestVersion = docsElement.get("latestVersion");
        Object version = docsElement.get("v");
        return (String)(latestVersion != null ? latestVersion : version);
    }

    private String getArtifactId(Map<String, Object> docsElement) {
        return (String)docsElement.get("a");
    }

    private String getGroupId(Map<String, Object> docsElement) {
        return (String)docsElement.get("g");
    }

    private int getTotalHitCount(Map<String, Object> jsonMap) {
        int numFound = Double.valueOf((Double)this.getResponse(jsonMap).get("numFound")).intValue();
        return numFound;
    }

    private Map<String, Object> getResponse(Map<String, Object> jsonMap) {
        Map response = (Map)jsonMap.get("response");
        return response;
    }

    private boolean getStatus(Map<String, Object> jsonMap) {
        Map responseHeader = (Map)jsonMap.get("responseHeader");
        int status = Double.valueOf((Double)responseHeader.get("status")).intValue();
        return status == 0;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public int getTotalHitCount() {
        return this.totalHitCount;
    }

    public List<Map<String, String>> getArtifacts() {
        return this.artifacts != null ? this.artifacts : Collections.emptyList();
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }
}

