/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.query.internal.central;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.mule.tooling.core.m2.MavenModelHelper;
import org.mule.tooling.core.m2.query.MavenQuery;
import org.mule.tooling.core.m2.query.MavenQueryCallback;
import org.mule.tooling.core.m2.query.MavenQueryResult;
import org.mule.tooling.core.m2.query.MavenQueryResultItem;
import org.mule.tooling.maven.query.internal.DefaultQueryResultItem;
import org.mule.tooling.maven.query.internal.FailureQueryResult;
import org.mule.tooling.maven.query.internal.SuccessQueryResult;
import org.mule.tooling.maven.query.internal.central.MavenCentralClient;
import org.mule.tooling.maven.query.internal.central.MavenCentralResponse;

public abstract class MavenCentralQuery
implements MavenQuery {
    private static final int ROWS = 10;
    private MavenCentralClient mavenCentralClient = MavenCentralClient.create();
    private int offset = 0;

    protected abstract Map<String, String> getParamsMap();

    public void execute(MavenQueryCallback callback, IProgressMonitor monitor) {
        this.execute(callback, this.offset, monitor);
    }

    public void execute(MavenQueryCallback callback, int _offset, IProgressMonitor monitor) {
        String name = this.getTaskName();
        monitor.beginTask(name, 4);
        monitor.subTask(name);
        try {
            monitor.worked(1);
            Map<String, String> params = this.getParamsMap();
            monitor.worked(1);
            if (!monitor.isCanceled()) {
                MavenCentralResponse response = this.mavenCentralClient.search(params, _offset, 10);
                this.offset += response.getArtifacts().size();
                monitor.worked(1);
                callback.finished(this.toQueryResult(response, _offset));
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected abstract String getTaskName();

    protected String encode(String searchTerm) {
        try {
            return URLEncoder.encode(searchTerm, "UTF-8").replaceAll("\\+", " ");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private MavenQueryResult toQueryResult(MavenCentralResponse response, int offset) {
        MavenQueryResult result = null;
        result = response.isSuccessful() ? SuccessQueryResult.withResults(this.toResultItemList(response.getArtifacts()), offset, response.getTotalHitCount(), this) : FailureQueryResult.withMessage(response.getFailureMessage());
        return result;
    }

    private List<MavenQueryResultItem> toResultItemList(List<Map<String, String>> artifacts) {
        ArrayList<MavenQueryResultItem> itemList = new ArrayList<MavenQueryResultItem>(artifacts.size());
        for (Map<String, String> artifactMap : artifacts) {
            String groupId = artifactMap.get("key_groupId");
            String artifactId = artifactMap.get("key_artifactId");
            String version = artifactMap.get("key_latestver");
            double accuracy = this.getAccuracy(groupId, artifactId, version);
            DefaultQueryResultItem item = new DefaultQueryResultItem(MavenModelHelper.mavenDependency((String[])new String[]{groupId, artifactId, version}), null, accuracy);
            itemList.add(item);
        }
        return itemList;
    }

    protected abstract double getAccuracy(String var1, String var2, String var3);
}

