/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.query.internal.central;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.mule.tooling.core.m2.MavenResourceUtils;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.query.MavenArtifactDownloadDelegate;
import org.mule.tooling.maven.MavenPlugin;
import org.mule.tooling.maven.query.internal.central.MavenCentralResponse;
import org.mule.tooling.utils.io.ProgressTrackingInputStream;

public class MavenCentralClient
implements MavenArtifactDownloadDelegate {
    private static final String SEP = "/";
    private static final String REMOTECONTENT = "remotecontent";
    private static final String SELECT = "select";
    private static final String SEARCH = "solrsearch";
    private static final String FILEPATH = "filepath";
    private static final String CENTRAL_BASEURL = "https://search.maven.org";
    private static final String DOWNLOAD_URL = "https://search.maven.org/remotecontent";
    private static final String SEARCH_URL = "https://search.maven.org/solrsearch/select";
    private WebTarget searchResource;
    private WebTarget downloadResource;

    public static MavenCentralClient create() {
        return Singleton.instance;
    }

    private MavenCentralClient() {
        Client client = ClientBuilder.newClient();
        this.searchResource = client.target(SEARCH_URL);
        this.downloadResource = client.target(DOWNLOAD_URL);
    }

    public MavenCentralResponse search(Map<String, String> params, int offset, int rows) {
        WebTarget target = this.searchResource;
        Set<Map.Entry<String, String>> entrySet = params.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            target = target.queryParam(entry.getKey(), new Object[]{entry.getValue()});
        }
        if (offset != 0) {
            target = target.queryParam("start", new Object[]{"" + offset});
        }
        Response clientResponse = target.queryParam("rows", new Object[]{"" + rows}).queryParam("wt", new Object[]{"json"}).request().get();
        return new MavenCentralResponse(clientResponse);
    }

    public boolean download(MavenDependency artifact, File targetFile, IProgressMonitor monitor) {
        String filePath = MavenResourceUtils.getRepositoryPath((MavenDependency)artifact, (String)SEP);
        Response clientResponse = this.downloadResource.queryParam(FILEPATH, new Object[]{filePath}).request().get();
        String informativeUrl = this.downloadResource.getUri().toString();
        return this.download(clientResponse, informativeUrl, targetFile, monitor);
    }

    protected boolean download(Response response, String informativeUrl, File resultFile, IProgressMonitor progressMonitor) {
        try {
            Response.Status responseStatus = Response.Status.fromStatusCode((int)response.getStatus());
            if (Response.Status.OK.equals((Object)responseStatus)) {
                return this.doDownload(response, informativeUrl, resultFile, progressMonitor);
            }
            if (Response.Status.FOUND.equals((Object)responseStatus)) {
                return this.handleRedirect(response, resultFile, progressMonitor);
            }
            if (Response.Status.NOT_FOUND.equals((Object)responseStatus)) {
                MavenPlugin.logWarning("Artifact not found at " + String.valueOf(response.getLocation()));
            } else {
                String message = MessageFormat.format("Received response {0} from url {1} with message {2}", responseStatus, informativeUrl, response.readEntity(String.class));
                MavenPlugin.logWarning(message);
            }
        }
        catch (IOException iOException) {
            MavenPlugin.logWarning("There was a problem downloading a maven artifact from " + informativeUrl);
        }
        return false;
    }

    protected boolean handleRedirect(Response response, File resultFile, IProgressMonitor monitor) {
        URI locationHeader = response.getLocation();
        if (locationHeader != null) {
            Response clientResponse = ClientBuilder.newClient().target(locationHeader).request().get();
            return this.download(clientResponse, locationHeader.toString(), resultFile, monitor);
        }
        throw new RuntimeException("Not found " + String.valueOf(response.getLocation()));
    }

    protected boolean doDownload(Response response, String informativeUrl, File tempFile, IProgressMonitor monitor) throws IOException {
        int totalWork = this.getContentLength(response);
        try {
            block13: {
                Throwable throwable = null;
                Object var7_8 = null;
                InputStream entityInputStream = (InputStream)response.readEntity(InputStream.class);
                try {
                    monitor.beginTask("Downloading " + informativeUrl, totalWork);
                    FileUtils.copyInputStreamToFile((InputStream)new ProgressTrackingInputStream(entityInputStream, monitor), (File)tempFile);
                    if (entityInputStream == null) break block13;
                }
                catch (Throwable throwable2) {
                    try {
                        if (entityInputStream != null) {
                            entityInputStream.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                entityInputStream.close();
            }
            return true;
        }
        finally {
            monitor.done();
        }
    }

    private int getContentLength(Response response) {
        List list = (List)response.getStringHeaders().get((Object)"Content-Length");
        String contentLength = list != null && !list.isEmpty() ? (String)list.get(0) : null;
        int totalWork = StringUtils.isNotBlank(contentLength) ? Integer.valueOf(contentLength) : 100000;
        return totalWork;
    }

    private static class Singleton {
        private static final MavenCentralClient instance = new MavenCentralClient();

        private Singleton() {
        }
    }
}

