/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.query.internal.central;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.maven.query.internal.central.MavenCentralQuery;

public class MavenCentralAdvancedSearchQuery
extends MavenCentralQuery {
    private String artifactId;
    private String version;
    private String groupId;

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Override
    protected Map<String, String> getParamsMap() {
        ArrayList<String> preParams = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)this.groupId)) {
            preParams.add(MessageFormat.format("g:\"{0}\"", this.groupId));
        }
        if (StringUtils.isNotBlank((String)this.artifactId)) {
            preParams.add(MessageFormat.format("a:\"{0}\"", this.artifactId));
        }
        if (StringUtils.isNotBlank((String)this.version)) {
            preParams.add(MessageFormat.format("v:\"{0}\"", this.version));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        String query = StringUtils.join(preParams, (String)"%20AND%20");
        params.put("q", query);
        return params;
    }

    @Override
    protected String getTaskName() {
        StringBuilder searchTerm = new StringBuilder((String)(StringUtils.isBlank((String)this.groupId) ? "" : this.groupId + ":"));
        searchTerm.append(this.artifactId);
        searchTerm.append(":");
        searchTerm.append(this.version);
        return "Searching Maven Central (advanced) for " + searchTerm.toString();
    }

    @Override
    protected double getAccuracy(String groupId, String artifactId, String version) {
        return 1.0;
    }
}

