/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.query.internal.central;

import org.mule.tooling.core.m2.query.MavenQuery;
import org.mule.tooling.core.m2.query.MavenQueryBuilder;
import org.mule.tooling.maven.query.internal.NoOpQuery;
import org.mule.tooling.maven.query.internal.central.MavenCentralAdvancedSearchQuery;

public class MavenCentralAdvancedSearchBuilder
implements MavenQueryBuilder {
    private static final String VALID_SEPARATORS = "_\\-\\.:";
    private static final String UPPERCASE_CHARS = "A-Z";
    private static final String LOWERCASE_CHARS = "a-z";
    private static final String NUMBERS = "0-9";
    private static final String GAV_VALID_CHARACTERS_REGEX = "[0-9a-zA-Z_\\-\\.:]+";
    private String searchTerm;

    public MavenQueryBuilder setSearchTerm(String searchTerm) {
        this.searchTerm = searchTerm;
        return this;
    }

    public MavenQuery build() {
        int gavSeparatorIndex = this.searchTerm.indexOf(":");
        NoOpQuery query = null;
        query = gavSeparatorIndex != -1 && this.isHealthyInput(this.searchTerm) ? this.doBuild() : new NoOpQuery();
        return query;
    }

    private boolean isHealthyInput(String searchTerm) {
        return searchTerm.matches(GAV_VALID_CHARACTERS_REGEX);
    }

    private MavenQuery doBuild() {
        MavenCentralAdvancedSearchQuery query = new MavenCentralAdvancedSearchQuery();
        String[] split = this.searchTerm.split(":");
        int length = split.length;
        if (length == 2 && this.isVersionLike(split[1])) {
            query.setArtifactId(split[0]);
            query.setVersion(split[1]);
        } else if (length == 2 && !this.isVersionLike(split[1])) {
            query.setGroupId(split[0]);
            query.setArtifactId(split[1]);
        } else if (length == 3 && this.isVersionLike(split[2])) {
            query.setGroupId(split[0]);
            query.setArtifactId(split[1]);
            query.setVersion(split[2]);
        }
        return query;
    }

    private boolean isVersionLike(String string) {
        boolean isLatest = "LATEST".equals(string);
        boolean isRelease = "RELEASE".equals(string);
        boolean startsWithNumber = string.matches("[0-9]+.*");
        return isLatest || isRelease || startsWithNumber;
    }
}

