/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.query.internal.central;

import com.google.common.util.concurrent.FutureCallback;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.mule.tooling.core.m2.MavenResourceUtils;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.core.m2.query.MavenArtifactDownloadDelegate;
import org.mule.tooling.core.m2.query.MavenArtifactDownloader;
import org.mule.tooling.core.m2.query.MavenArtifactRequest;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.maven.MavenPlugin;
import org.mule.tooling.maven.utils.MavenUtils;
import org.mule.tooling.utils.concurrent.CurrentThreadNamingRunnable;

public class AsyncMavenArtifactDownloader
implements MavenArtifactDownloader {
    private static final int THREAD_COUNT = 4;
    private MavenArtifactDownloadDelegate delegate;
    private ExecutorService executorService;

    public AsyncMavenArtifactDownloader(MavenArtifactDownloadDelegate delegate) {
        this.delegate = delegate;
        this.executorService = Executors.newFixedThreadPool(4);
    }

    protected MavenArtifactDownloadDelegate getDownloadDelegate() {
        return this.delegate;
    }

    public void download(MavenArtifactRequest request, FutureCallback<File> callback, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        MavenDependency artifact = request.getArtifact();
        String groupId = artifact.getGroupId();
        String artifactId = artifact.getArtifactId();
        String version = artifact.getVersion();
        if (CoreUtils.areNotBlank((String[])new String[]{groupId, artifactId, version})) {
            this.scheduleDownload(artifact, callback, monitor);
        } else {
            MavenPlugin.logError("Invalid artifact for download request: " + MavenUtils.getGavString(artifact));
        }
    }

    protected void scheduleDownload(MavenDependency artifact, FutureCallback<File> callback, IProgressMonitor monitor) {
        DownloadArtifactRunnable task = new DownloadArtifactRunnable(this.getDownloadDelegate(), artifact, callback, monitor);
        this.executorService.submit((Runnable)((Object)task));
    }

    private static class DownloadArtifactRunnable
    extends CurrentThreadNamingRunnable {
        private MavenArtifactDownloadDelegate downloadDelegate;
        private MavenDependency artifact;
        private FutureCallback<File> callback;
        private IProgressMonitor monitor;

        public DownloadArtifactRunnable(MavenArtifactDownloadDelegate downloadDelegate, MavenDependency artifact, FutureCallback<File> callback, IProgressMonitor monitor) {
            super("DownloadArtifactThread (" + MavenUtils.getGavString(artifact) + ")", true);
            this.downloadDelegate = downloadDelegate;
            this.artifact = artifact;
            this.callback = callback;
            this.monitor = monitor;
        }

        public void doRun() {
            File targetFile = new File(MavenCore.getM2repoPath(), MavenResourceUtils.getRepositoryPath((MavenDependency)this.artifact, (String)File.separator));
            Exception exception = null;
            boolean success = false;
            try {
                success = this.downloadDelegate.download(this.artifact, targetFile, this.monitor);
            }
            catch (Exception e) {
                MavenPlugin.logError("There was an unexpected error downloading " + MavenUtils.getGavString(this.artifact), e);
                exception = e;
            }
            if (success) {
                this.callback.onSuccess((Object)targetFile);
            } else {
                this.callback.onFailure((Throwable)exception);
            }
        }
    }
}

