/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.query.internal;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.mule.tooling.core.m2.query.MavenQuery;
import org.mule.tooling.core.m2.query.MavenQueryCallback;
import org.mule.tooling.core.m2.query.MavenQueryResult;
import org.mule.tooling.core.m2.query.MavenQueryResultItem;

public class SuccessQueryResult
implements MavenQueryResult {
    private List<MavenQueryResultItem> results;
    private int totalResults;
    private MavenQuery originatingQuery;
    private int offset;
    private boolean fetchedNextResults;

    public static MavenQueryResult withResults(List<MavenQueryResultItem> results, int offset, int totalResults, MavenQuery originatingQuery) {
        return new SuccessQueryResult(results, offset, totalResults, originatingQuery);
    }

    private SuccessQueryResult(List<MavenQueryResultItem> results, int offset, int totalResults, MavenQuery originatingQuery) {
        this.results = results;
        this.offset = offset;
        this.totalResults = totalResults;
        this.originatingQuery = originatingQuery;
    }

    public boolean isSuccesful() {
        return true;
    }

    public List<MavenQueryResultItem> getResults() {
        return this.results;
    }

    public void getNextResults(MavenQueryCallback callback, IProgressMonitor monitor) {
        if (!this.fetchedNextResults && this.offset + this.results.size() < this.totalResults) {
            this.originatingQuery.execute(callback, this.offset + this.results.size() + 1, monitor);
            this.fetchedNextResults = true;
        }
    }

    public String getFailureMessage() {
        throw new IllegalStateException();
    }

    public int getTotalResults() {
        return this.totalResults;
    }

    public int getOffset() {
        return this.offset;
    }

    public String toString() {
        return "SuccessQueryResult [totalResults=" + this.totalResults + ", offset=" + this.offset + ", results=" + String.valueOf(this.results) + ", originatingQuery=" + String.valueOf(this.originatingQuery) + ", fetchedNextResults=" + this.fetchedNextResults + "]";
    }
}

