/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.export;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.time.DateFormatUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.deployer.DefaultPackagingRequest;
import org.mule.tooling.core.deployer.PackagingRequest;
import org.mule.tooling.core.impl.model.DomainUtils;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.m2.IMavenPropertyResolver;
import org.mule.tooling.core.m2.MavenCorePreferences;
import org.mule.tooling.core.m2.MavenModelHelper;
import org.mule.tooling.core.m2.MavenResourceUtils;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.IMuleDomainProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.packageManager.IExportPackageManager;
import org.mule.tooling.core.packageManager.MuleExportStatus;
import org.mule.tooling.core.packageManager.PackagingOptions;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.VMUtils;
import org.mule.tooling.maven.MavenMuleProjectDecorator;
import org.mule.tooling.maven.cmdline.MavenCommandLine;
import org.mule.tooling.maven.runner.DefaultMavenRunnerConfiguration;
import org.mule.tooling.maven.runner.MavenExecutionException;
import org.mule.tooling.maven.runner.MavenRunner;
import org.mule.tooling.maven.runner.MavenRunnerBuilder;
import org.mule.tooling.maven.runner.MavenRunnerCallback;
import org.mule.tooling.maven.runner.SyncGetResultCallback;
import org.mule.tooling.maven.utils.MavenUtils;

public class MavenExportManager
implements IExportPackageManager {
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("(.*?)(\\$\\{.*?\\})(.*)");
    private static final String TEMPORARY_PROPERTIES_REGEX = "(.*?)\\$\\{(maven.build.timestamp)\\}(.*)";

    @Deprecated
    public MavenExportManager() {
    }

    /*
     * Exception decompiling
     */
    public MuleExportStatus export(PackagingRequest packagingRequest, IProgressMonitor progressMonitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 10 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void customizeOnlyResourcesPom(IMuleProject muleProject, IProgressMonitor monitor) throws CoreException {
        this.removeTempPomFileIfNecessary(muleProject);
        MavenDependency mavenDependency = MavenModelHelper.mavenDependency((String[])new String[]{muleProject.getMuleProjectModel().getGroupId(), muleProject.getMuleProjectModel().getArtifactId(), muleProject.getMuleProjectModel().getVersion()});
        IFile tempPomFile = MavenResourceUtils.createPomFile((String)".org.mule.tooling.pom", (Boolean)false, (MuleProjectKind)muleProject.getKind(), (IJavaProject)muleProject.getJavaProject(), (IServerDefinition)muleProject.getServerDefinition(), (MavenDependency)mavenDependency, (IProgressMonitor)monitor);
        this.hideFile(tempPomFile);
    }

    private void hideFile(IFile tempPomFile) throws CoreException {
        ResourceAttributes resourceAttributes = tempPomFile.getResourceAttributes();
        resourceAttributes.setHidden(true);
        tempPomFile.setResourceAttributes(resourceAttributes);
    }

    private void removeTempPomFileIfNecessary(IMuleProject muleProject) throws CoreException {
        IFile tempPom = muleProject.getProject().getFile(".org.mule.tooling.pom");
        if (tempPom.exists()) {
            tempPom.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static void installDomainProjectIfNecessary(IMuleProject muleProject, PipedOutputStream monitorStream) throws MavenExecutionException, InterruptedException {
        Optional domainCoordinates;
        Optional maybeDomainProject;
        if (MuleProjectKind.APPLICATION.classifies(muleProject) && (maybeDomainProject = (domainCoordinates = ((IMuleApplicationProject)MuleProjectKind.APPLICATION.adapt(muleProject)).getDomainCoordinates()).flatMap(DomainUtils::findDomainProjectSafely)).isPresent()) {
            IMuleDomainProject domainProject = (IMuleDomainProject)maybeDomainProject.get();
            MavenRunner mavenDomainRunner = MavenExportManager.initializeMavenRunner((IMuleProject)domainProject);
            try {
                if (MuleResourceUtils.getLastModificationTimeStamp((IJavaProject)domainProject.getJavaProject()) > CoreUtils.getFileInLocalRepo((MavenDependency)domainProject.getMavenCoordinates()).lastModified()) {
                    DefaultPackagingRequest domainPackagingRequest = DefaultPackagingRequest.builder((IMuleProject)domainProject).attachSources().build();
                    MavenCommandLine commandDomainline = MavenUtils.getCommandLine("mvn clean install", (PackagingRequest)domainPackagingRequest);
                    SyncGetResultCallback callback = new SyncGetResultCallback();
                    mavenDomainRunner.run(MavenMuleProjectDecorator.decorate((IMuleProject)domainProject).getPomFile(), commandDomainline, (MavenRunnerCallback)callback, (OutputStream)monitorStream);
                    callback.getResult();
                }
            }
            catch (CoreException e) {
                MuleCorePlugin.logError((String)("Error when getting last modification time from domain project " + String.valueOf(domainProject)), (Throwable)e);
            }
        }
    }

    private void logOutput(String loggingOutStream, IMuleProject muleProject) throws IOException {
        MuleCorePlugin.logWarning((String)("Log output for packaging project " + muleProject.getName() + "\n" + loggingOutStream));
    }

    private void printMavenCommand(PrintStream printStream, MavenCommandLine commandline) {
        printStream.println();
        printStream.append("[");
        printStream.append(DateFormatUtils.ISO_TIME_NO_T_FORMAT.format(new Date()));
        printStream.append("] ");
        printStream.append("Running: " + commandline.getCommand());
        printStream.println();
    }

    private static MavenRunner initializeMavenRunner(IMuleProject muleProject) {
        boolean useExternalMaven = !MavenCorePreferences.isEmbeddedMaven();
        String mavenHomeDirectory = MavenCorePreferences.getMavenPath();
        DefaultMavenRunnerConfiguration runnerConfiguration = new DefaultMavenRunnerConfiguration(useExternalMaven, mavenHomeDirectory, "");
        return MavenRunnerBuilder.with(runnerConfiguration).setJavaHome(VMUtils.getDefaultJvmHome((IJavaProject)muleProject.getJavaProject())).build();
    }

    public static File findFileWithProperties(File targetFolder, String expectedZipFileName, BiFunction<List<File>, String, File> onMultipleResults) {
        String replaced = MavenExportManager.escapeKnowConflictiveCharacters(MavenExportManager.replaceMissingProperties(expectedZipFileName, null, false));
        File[] targetFiles = targetFolder.listFiles();
        LinkedList<File> candidateFiles = new LinkedList<File>();
        File[] fileArray = targetFiles;
        int n = targetFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().matches(replaced)) {
                candidateFiles.add(file);
            }
            ++n2;
        }
        if (candidateFiles.size() > 1) {
            return onMultipleResults.apply(candidateFiles, expectedZipFileName);
        }
        return candidateFiles.isEmpty() ? null : (File)candidateFiles.get(0);
    }

    private static String escapeKnowConflictiveCharacters(String expectedZipFileName) {
        return expectedZipFileName.replace("+", "\\+");
    }

    private static String replaceMissingProperties(String expectedZipFileName, IMavenPropertyResolver mavenPropertyResolver, boolean resolve) {
        Matcher matcher = PROPERTY_PATTERN.matcher(expectedZipFileName);
        if (matcher.find()) {
            StringBuilder stringBuilder = new StringBuilder();
            String leftGroup = matcher.group(1);
            if (leftGroup != null) {
                stringBuilder.append(leftGroup);
            }
            if (resolve) {
                String property = matcher.group(2);
                if (!property.matches(TEMPORARY_PROPERTIES_REGEX)) {
                    stringBuilder.append(mavenPropertyResolver.resolveProperties(property));
                } else {
                    stringBuilder.append(property);
                }
            } else {
                stringBuilder.append(".*?");
            }
            String rightGroup = matcher.group(3);
            if (rightGroup != null) {
                stringBuilder.append(MavenExportManager.replaceMissingProperties(rightGroup, mavenPropertyResolver, resolve));
            }
            return stringBuilder.toString();
        }
        return expectedZipFileName;
    }

    public static String getExpectedJarFileName(PackagingRequest packagingRequest, Properties properties) {
        MavenMuleProjectDecorator mavenDecorator = MavenMuleProjectDecorator.decorate(packagingRequest.getProject());
        String artifactFinalName = mavenDecorator.getArtifactFinalName(MavenExportManager.getPackagingOptions(packagingRequest), properties);
        return artifactFinalName + ".jar";
    }

    private static String getExpectedJarRawFileName(PackagingRequest packagingRequest) {
        MavenMuleProjectDecorator mavenDecorator = MavenMuleProjectDecorator.decorate(packagingRequest.getProject());
        Object artifactFinalName = mavenDecorator.getRawArtifactFinalName(MavenExportManager.getPackagingOptions(packagingRequest));
        artifactFinalName = (String)artifactFinalName + ".jar";
        artifactFinalName = MavenExportManager.replaceMissingProperties((String)artifactFinalName, mavenDecorator.getPropertyResolver(), true);
        return artifactFinalName;
    }

    private static PackagingOptions getPackagingOptions(PackagingRequest packagingRequest) {
        return PackagingOptions.builder().lightweightPackage(packagingRequest.isLightweight()).testJar(packagingRequest.getOption("export.test_jar").isPresent()).build();
    }

    public static File findResultFile(PackagingRequest packagingRequest, File targetFolder, BiFunction<List<File>, String, File> onMultipleResults, Properties properties) {
        String expectedJarFileName = MavenExportManager.getExpectedJarFileName(packagingRequest, properties);
        String expectedJarRawFileName = MavenExportManager.getExpectedJarRawFileName(packagingRequest);
        if (expectedJarRawFileName != null && expectedJarRawFileName.matches(TEMPORARY_PROPERTIES_REGEX)) {
            return MavenExportManager.findFileWithProperties(targetFolder, expectedJarRawFileName, onMultipleResults);
        }
        return MavenExportManager.findFileWithProperties(targetFolder, expectedJarFileName, onMultipleResults);
    }

    private static /* synthetic */ File lambda$0(List candidates, String n) {
        return (File)candidates.get(0);
    }
}

