/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.exchange.service;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import jakarta.inject.Inject;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Response;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.auth.AuthUser;
import org.mule.tooling.core.auth.PlatformUrls;
import org.mule.tooling.core.net.ConnectionManager;
import org.mule.tooling.core.utils.EclipseContextHelper;
import org.mule.tooling.maven.exchange.service.error.ExchangeUnauthorizedException;

public class ExchangeClient {
    private Gson gson = new Gson();
    private final ConnectionManager connectionManager;
    private String activeExchangeXAPIURL;

    public static ExchangeClient getExchangeClient() {
        return (ExchangeClient)EclipseContextHelper.createFromStudioContext(ExchangeClient.class);
    }

    @Inject
    public ExchangeClient(ConnectionManager connectionManager) {
        this(connectionManager, PlatformUrls.getActiveExchangeXAPIUrl());
    }

    public ExchangeClient(ConnectionManager connectionManager, String platformActiveUrl) {
        this.connectionManager = connectionManager;
        this.activeExchangeXAPIURL = platformActiveUrl;
    }

    private Client getClient(Optional<URI> uri) {
        Client restClient = uri.isPresent() ? this.connectionManager.createJerseyClientForUri(uri.get()) : ClientBuilder.newClient();
        restClient.property("jersey.config.client.connectTimeout", (Object)5000);
        restClient.property("jersey.config.client.readTimeout", (Object)5000);
        return restClient;
    }

    public String getGroupID(AuthUser activeUser, String organizationId) {
        List<ExchangeDTO> groupIDs = this.getGroupIDs(activeUser, organizationId);
        if (groupIDs != null) {
            return groupIDs.get(0).getGroupId();
        }
        return null;
    }

    public List<ExchangeDTO> getGroupIDs(AuthUser activeUser, String organizationId) {
        Type listType;
        String groupIdPath = "/organizations/" + organizationId + "/groups";
        List<ExchangeDTO> result = this.execute(groupIdPath, activeUser, listType = new TypeToken<List<ExchangeDTO>>(){}.getType());
        if (!result.isEmpty()) {
            return result;
        }
        return null;
    }

    public List<ExchangeCategoryDTO> getCategories(AuthUser activeUser, String organizationId) {
        Type listType;
        String groupIdPath = "/organizations/" + organizationId + "/categories";
        List<ExchangeCategoryDTO> result = this.execute(groupIdPath, activeUser, listType = new TypeToken<List<ExchangeCategoryDTO>>(){}.getType());
        if (!result.isEmpty()) {
            return result;
        }
        return new ArrayList<ExchangeCategoryDTO>();
    }

    public List<ExchangeCustomFieldDTO> getCustomFields(AuthUser activeUser, String organizationId) {
        Type listType;
        String groupIdPath = "/organizations/" + organizationId + "/fields";
        List<ExchangeCustomFieldDTO> result = this.execute(groupIdPath, activeUser, listType = new TypeToken<List<ExchangeCustomFieldDTO>>(){}.getType());
        if (result.isEmpty()) {
            return new ArrayList<ExchangeCustomFieldDTO>();
        }
        return result;
    }

    private List<?> execute(String url, AuthUser user, Type resourceType) {
        Client client = this.getClient(Optional.empty());
        try {
            client = this.getClient(Optional.of(new URI(this.activeExchangeXAPIURL)));
        }
        catch (URISyntaxException e) {
            MuleCorePlugin.logError((String)"Exchange service URL is not valid. Please check your configuration", (Throwable)e);
        }
        Response response = client.target(this.activeExchangeXAPIURL).path(url).request().header("Authorization", (Object)("Bearer " + user.getToken())).get();
        if (response.getStatus() == 403) {
            throw new ExchangeUnauthorizedException(response.getStatus());
        }
        if (response.getStatus() != 200) {
            throw new RuntimeException("Failed request " + url + " with status code " + response.getStatus());
        }
        return (List)this.gson.fromJson((String)response.readEntity(String.class), resourceType);
    }

    public static class ExchangeCategoryDTO {
        private String tagKey;
        private String displayName;
        private List<String> acceptedValues;
        private List<String> assetTypeRestrictions;

        public ExchangeCategoryDTO(String tagKey, String displayName, List<String> acceptedValues, List<String> assetTypeRestrictions) {
            this.tagKey = tagKey;
            this.displayName = displayName;
            this.acceptedValues = acceptedValues;
            this.assetTypeRestrictions = assetTypeRestrictions;
        }

        public String getTagKey() {
            return this.tagKey;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public List<String> getAcceptedValues() {
            return this.acceptedValues;
        }

        public List<String> getAssetTypeRestrictions() {
            return this.assetTypeRestrictions;
        }
    }

    public static class ExchangeCustomFieldDTO {
        private String tagKey;
        private String displayName;
        private String dataType;
        private List<String> acceptedValues;
        private List<String> assetTypeRestrictions;

        public ExchangeCustomFieldDTO(String tagKey, String displayName, String dataType, List<String> acceptedValues, List<String> assetTypeRestrictions) {
            this.tagKey = tagKey;
            this.displayName = displayName;
            this.dataType = dataType;
            this.acceptedValues = acceptedValues;
            this.assetTypeRestrictions = assetTypeRestrictions;
        }

        public String getTagKey() {
            return this.tagKey;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public List<String> getAcceptedValues() {
            return this.acceptedValues;
        }

        public List<String> getAssetTypeRestrictions() {
            return this.assetTypeRestrictions;
        }

        public String getDataType() {
            return this.dataType;
        }

        public boolean acceptsAssetType(String assetType) {
            return this.assetTypeRestrictions.isEmpty() || this.assetTypeRestrictions.contains(assetType);
        }
    }

    public static class ExchangeDTO {
        private String groupId;

        public ExchangeDTO(String groupId) {
            this.groupId = groupId;
        }

        public String getGroupId() {
            return this.groupId;
        }
    }
}

