/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.dependency;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.mule.tooling.core.m2.dependency.InvalidDependency;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.dependency.PojoMavenDependency;
import org.mule.tooling.core.m2.dependency.PojoMavenDependencyBuilder;
import org.mule.tooling.maven.dependency.EnterpriseMuleModule;
import org.mule.tooling.maven.dependency.EnterpriseMuleTransport;
import org.mule.tooling.maven.dependency.MuleModule;
import org.mule.tooling.maven.dependency.MuleTransport;

public class NamespaceToDependencyResolver {
    private static final PojoMavenDependency MULE_CORE_DEPENDENCY = ((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)PojoMavenDependencyBuilder.newInstance().withGroupId("org.mule")).withArtifactId("mule-core")).withVersion("${mule.version}")).withScope(MavenDependency.Scope.PROVIDED)).build();
    private static final PojoMavenDependency MULE_CORE_EE_DEPENDENCY = ((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)PojoMavenDependencyBuilder.newInstance().withGroupId("com.mulesoft.mule")).withArtifactId("mule-core-ee")).withVersion("${mule.version}")).withScope(MavenDependency.Scope.PROVIDED)).build();
    private static Map<String, PojoMavenDependency> namespaceToDependencyMap = new HashMap<String, PojoMavenDependency>();
    private String namespace;

    static {
        namespaceToDependencyMap.put("http://www.mulesoft.org/schema/mule/ajax", new MuleTransport("ajax"));
        namespaceToDependencyMap.put("http://www.mulesoft.org/schema/mule/jdbc", new MuleTransport("jdbc"));
        namespaceToDependencyMap.put("http://www.mulesoft.org/schema/mule/ee/jdbc", new EnterpriseMuleTransport("jdbc"));
        namespaceToDependencyMap.put("http://www.mulesoft.org/schema/mule/file", new MuleTransport("file"));
        namespaceToDependencyMap.put("http://www.mulesoft.org/schema/mule/ftp", new MuleTransport("ftp"));
        namespaceToDependencyMap.put("http://www.mulesoft.org/schema/mule/ee/ftp", new EnterpriseMuleTransport("ftp"));
        namespaceToDependencyMap.put("http://www.mulesoft.org/schema/mule/http", new MuleTransport("http"));
        namespaceToDependencyMap.put("http://www.mulesoft.org/schema/mule/imap", new MuleTransport("email"));
        namespaceToDependencyMap.put("http://www.mulesoft.org/schema/mule/smtp", new MuleTransport("email"));
        namespaceToDependencyMap.put("http://www.mulesoft.org/schema/mule/jms", new MuleTransport("jms"));
        namespaceToDependencyMap.put("http://www.mulesoft.org/schema/mule/jetty", new MuleTransport("jetty"));
        namespaceToDependencyMap.put("http://www.mulesoft.org/schema/mule/pop3", new MuleTransport("email"));
        namespaceToDependencyMap.put("http://www.mulesoft.org/schema/mule/quartz", new MuleTransport("quartz"));
        namespaceToDependencyMap.put("http://www.mulesoft.org/schema/mule/rmi", new MuleTransport("rmi"));
        namespaceToDependencyMap.put("http://www.mulesoft.org/schema/mule/sftp", new MuleTransport("sftp"));
        namespaceToDependencyMap.put("http://www.mulesoft.org/schema/mule/ssl", new MuleTransport("ssl"));
        namespaceToDependencyMap.put("http://www.mulesoft.org/schema/mule/servlet", new MuleTransport("servlet"));
        namespaceToDependencyMap.put("http://www.mulesoft.org/schema/mule/tcp", new MuleTransport("tcp"));
        namespaceToDependencyMap.put("http://www.mulesoft.org/schema/mule/udp", new MuleTransport("udp"));
        namespaceToDependencyMap.put("http://www.mulesoft.org/schema/mule/vm", new MuleTransport("vm"));
        namespaceToDependencyMap.put("http://www.mulesoft.org/schema/mule/ee/wmq", new EnterpriseMuleTransport("wmq"));
        namespaceToDependencyMap.put("http://www.mulesoft.org/schema/mule/scripting", new MuleModule("scripting"));
        namespaceToDependencyMap.put("http://www.mulesoft.org/schema/mule/jersey", new MuleModule("jersey"));
        namespaceToDependencyMap.put("http://www.mulesoft.org/schema/mule/cxf", new MuleModule("cxf"));
        namespaceToDependencyMap.put("http://www.mulesoft.org/schema/mule/ee/data-mapper", new EnterpriseMuleModule("data-mapper"));
        namespaceToDependencyMap.put("http://www.mulesoft.org/schema/mule/email", new MuleTransport("email"));
        namespaceToDependencyMap.put("http://www.mulesoft.org/schema/mule/json", new MuleModule("json"));
        namespaceToDependencyMap.put("http://www.mulesoft.org/schema/mule/xml", new MuleModule("xml"));
        namespaceToDependencyMap.put("http://www.mulesoft.org/schema/mule/ee/tracking", new EnterpriseMuleModule("tracking-ee"));
    }

    public static NamespaceToDependencyResolver forNamespace(String namespace) {
        return new NamespaceToDependencyResolver(namespace);
    }

    public NamespaceToDependencyResolver(String namespace) {
        this.namespace = namespace;
    }

    public MavenDependency resolve() {
        InvalidDependency dependency = InvalidDependency.INSTANCE;
        if (this.namespace.startsWith("http://www.mulesoft.org/schema/mule/core/")) {
            dependency = MULE_CORE_DEPENDENCY;
        } else if (this.namespace.startsWith("http://www.mulesoft.org/schema/mule/ee/core/")) {
            dependency = MULE_CORE_EE_DEPENDENCY;
        } else {
            Set<Map.Entry<String, PojoMavenDependency>> entrySet = namespaceToDependencyMap.entrySet();
            for (Map.Entry<String, PojoMavenDependency> entry : entrySet) {
                if (!this.namespace.startsWith(entry.getKey())) continue;
                dependency = (MavenDependency)entry.getValue();
            }
        }
        return dependency;
    }
}

