/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.cmdline;

public class MavenProperty {
    public static final MavenProperty SKIP_TEST_SHORT = MavenProperty.withKey("skipTests");
    public static final MavenProperty SKIP_TEST_LONG = MavenProperty.withValue("maven.test.skip", "true");
    private final String key;
    private final String value;

    public static MavenProperty withKey(String key) {
        return new MavenProperty(key);
    }

    public static MavenProperty withValue(String key, String value) {
        return new MavenProperty(key, value);
    }

    public MavenProperty(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public MavenProperty(String key) {
        this(key, null);
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MavenProperty other = (MavenProperty)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "MavenProperty [key=" + this.key + (String)(this.value != null ? ", value=" + this.value : "") + "]";
    }
}

