/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.cmdline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.tooling.maven.cmdline.MavenProperty;
import org.mule.tooling.utils.lang.StringUtilities;

public class MavenCommandLine {
    private static final String VALUE_IN_QUOTES = "\".+?\"";
    private static final String COMMA_WITH_WS = "\\s*,\\s*";
    private static final String PROFILE_NAME = "[^,\\s]+";
    private static final String PROFILE_REGEX = "-P\\s*((?:[^,\\s]+)(?:\\s*,\\s*(?:[^,\\s]++))*)";
    private static final String PROPERTY_NAME = "[^=\\s]+";
    private static final String PROPERTY_VALUE = "\\S+";
    private static final String PROPERTY_QUOTED_REGEX = "\"-D\\s*([^=\\s]+)(=.+?)?\"";
    private static final String PROPERTY_REGEX = "\"-D\\s*([^=\\s]+)(=.+?)?\"|-D\\s*([^=\\s]+)(=\".+?\"|=\\S+)?";
    private static final String GOALS_REGEX = "\\s([^\\s]{1}(?<!-)[^\\s]+)";
    private String command;
    private String rawCommandArguments;
    private List<String> arguments;
    private List<String> goals;
    private List<String> profiles;
    private List<MavenProperty> properties;

    private MavenCommandLine() {
    }

    private MavenCommandLine(String command) {
        this.command = command;
    }

    public static MavenCommandLine fromString(String commandline) {
        MavenCommandLine mavenCommandLine = new MavenCommandLine(commandline);
        mavenCommandLine.initialize();
        return mavenCommandLine;
    }

    public List<String> getArgumentsList() {
        return this.arguments;
    }

    public String getRawCommandArguments() {
        return this.rawCommandArguments;
    }

    public boolean isMavenVersionCommand() {
        return this.rawCommandArguments.startsWith("-v") || this.rawCommandArguments.startsWith("--v") || this.rawCommandArguments.contains(" -v") || this.rawCommandArguments.contains(" --v");
    }

    public List<MavenProperty> getProperties() {
        return this.properties;
    }

    public Properties getLiteralProperties() {
        Properties literalProperties = new Properties();
        this.getProperties().forEach(p -> {
            Object object = literalProperties.setProperty(p.getKey(), p.getValue() != null ? p.getValue() : Boolean.TRUE.toString());
        });
        return literalProperties;
    }

    public List<String> getProfiles() {
        return this.profiles;
    }

    public List<String> getGoals() {
        return this.goals;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean isDebug() {
        return this.matchesFlag("-X");
    }

    public boolean isOffline() {
        return this.matchesFlag("-o") || this.matchesFlag("--offline");
    }

    public Boolean isQuiet() {
        if (!this.matchesFlag("-q") && !this.matchesFlag("--quiet")) {
            return false;
        }
        return true;
    }

    public boolean isStrictChecksum() {
        return this.matchesFlag("-C") || this.matchesFlag("--strict-checksums");
    }

    public boolean isLaxChecksum() {
        return this.matchesFlag("-c") || this.matchesFlag("--lax-checksums");
    }

    public boolean isLogErrors() {
        return this.matchesFlag("-e") || this.matchesFlag("--errors");
    }

    public boolean isUpdateSnapshots() {
        return this.matchesFlag("-U") || this.matchesFlag("--update-snapshots");
    }

    public boolean isNoSnapshotUpdates() {
        return this.matchesFlag("-nsu") || this.matchesFlag("--no-snapshot-updates");
    }

    private boolean matchesFlag(String flag) {
        return this.command.matches(".*" + flag + "\\s.*|.*" + flag + "$");
    }

    public String toString() {
        return "MavenCommandLine [command=" + this.command + "]";
    }

    private void initialize() {
        this.rawCommandArguments = this.command.replaceAll("^mvn\\s+", "");
        this.arguments = StringUtilities.splitStringRespectingQuotes((String)this.rawCommandArguments, (String)" ");
        this.goals = this.loadGoals();
        this.properties = this.loadProperties();
        this.profiles = this.loadProfiles();
    }

    private List<String> loadGoals() {
        String auxiliaryCommand = this.command.replaceAll("\\s*\"[^\"]+\"", "x");
        auxiliaryCommand = auxiliaryCommand.replaceAll(PROFILE_REGEX, "");
        auxiliaryCommand = auxiliaryCommand.replaceAll("\\s-\\w+\\s*[^\\s]+", "");
        ArrayList<String> goals = new ArrayList<String>();
        Pattern pattern = Pattern.compile(GOALS_REGEX);
        Matcher matcher = pattern.matcher(auxiliaryCommand);
        while (matcher.find()) {
            String goal = matcher.group(1);
            goals.add(goal);
        }
        return goals;
    }

    private List<String> loadProfiles() {
        ArrayList<String> profiles = new ArrayList<String>();
        Pattern pattern = Pattern.compile(PROFILE_REGEX);
        Matcher matcher = pattern.matcher(this.command);
        while (matcher.find()) {
            String group = matcher.group(1);
            profiles.addAll(Arrays.asList(group.split(COMMA_WITH_WS)));
        }
        return profiles;
    }

    private List<MavenProperty> loadProperties() {
        ArrayList<MavenProperty> properties = new ArrayList<MavenProperty>();
        Matcher matcher = Pattern.compile(PROPERTY_REGEX).matcher(this.command);
        while (matcher.find()) {
            String propertyName;
            String string = propertyName = matcher.group(1) != null ? matcher.group(1) : matcher.group(3);
            String propertyValue = matcher.group(2) != null ? matcher.group(2).substring(1) : (matcher.group(4) != null ? matcher.group(4).substring(1) : null);
            properties.add(new MavenProperty(propertyName, propertyValue));
        }
        return properties;
    }
}

