/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IPath;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.module.IMuleModuleManager;
import org.mule.tooling.core.runtime.server.ClasspathElementDefinition;
import org.mule.tooling.core.runtime.server.ConfigFolderDefinition;
import org.mule.tooling.core.runtime.server.ISchemaLocationLookup;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.runtime.server.LibraryFolderDefinition;
import org.mule.tooling.core.runtime.server.MuleLauncherClasspathElement;
import org.mule.tooling.core.runtime.server.StartsWithSearchingStringMap;
import org.mule.tooling.core.runtime.server.defaultextensions.RuntimeDefaultExtensions;

public class MavenServerDefinitionDecorator
implements IServerDefinition {
    private IServerDefinition serverDefinition;
    private StartsWithSearchingStringMap namespaceToMavenCoordinatesMap;

    public MavenServerDefinitionDecorator(IServerDefinition serverDefinition) {
        this.serverDefinition = serverDefinition;
    }

    public StartsWithSearchingStringMap getNamespaceToMavenCoordinatesMap() {
        if (this.namespaceToMavenCoordinatesMap == null) {
            this.initializeNamespaceToCoordinatesMap();
        }
        return this.namespaceToMavenCoordinatesMap;
    }

    public boolean hasMavenDependency(String namespace) {
        return this.getNamespaceToMavenCoordinatesMap().contains(namespace);
    }

    public String getCoordinatesFor(String namespace) {
        return (String)this.getNamespaceToMavenCoordinatesMap().get(namespace);
    }

    private void initializeNamespaceToCoordinatesMap() {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            try {
                IPath schemasPath = this.getPluginBaseDirectory().append("schemas");
                IPath namespaceToMavenPath = schemasPath.append("namespace-to-maven");
                File namespaceToMavenFile = namespaceToMavenPath.toFile();
                if (namespaceToMavenFile.exists()) {
                    fileInputStream = new FileInputStream(namespaceToMavenFile);
                    properties.load(fileInputStream);
                    this.namespaceToMavenCoordinatesMap = new StartsWithSearchingStringMap(properties);
                }
            }
            catch (IOException e) {
                MuleCorePlugin.logError((String)"Error initializing the maven artifacts data ", (Throwable)e);
                IOUtils.closeQuietly(fileInputStream);
                if (this.namespaceToMavenCoordinatesMap == null) {
                    this.namespaceToMavenCoordinatesMap = StartsWithSearchingStringMap.EMPTY;
                }
            }
        }
        finally {
            IOUtils.closeQuietly(fileInputStream);
            if (this.namespaceToMavenCoordinatesMap == null) {
                this.namespaceToMavenCoordinatesMap = StartsWithSearchingStringMap.EMPTY;
            }
        }
    }

    public int hashCode() {
        return this.serverDefinition.hashCode();
    }

    public String getId() {
        return this.serverDefinition.getId();
    }

    public boolean equals(Object obj) {
        return this.serverDefinition.equals(obj);
    }

    public String getLabel() {
        return this.serverDefinition.getLabel();
    }

    public String getVersionSuffix() {
        return this.serverDefinition.getVersionSuffix();
    }

    public String getVersion() {
        return this.serverDefinition.getVersion();
    }

    public String getVersionWithPatchVersionZero() {
        return this.serverDefinition.getVersionWithPatchVersionZero();
    }

    public String getVersionWithEESign() {
        return this.serverDefinition.getVersionWithEESign();
    }

    public String getDebuggerVersion() {
        return this.serverDefinition.getDebuggerVersion();
    }

    public IPath getSourceFilePath() {
        return this.serverDefinition.getSourceFilePath();
    }

    public List<LibraryFolderDefinition> getLibraryFolders() {
        return this.serverDefinition.getLibraryFolders();
    }

    public ISchemaLocationLookup getSchemaLocationlookup() {
        return this.serverDefinition.getSchemaLocationlookup();
    }

    public boolean isEnterpriseRuntime() {
        return this.serverDefinition.isEnterpriseRuntime();
    }

    public String getVersionWithSuffix() {
        return this.serverDefinition.getVersionWithSuffix();
    }

    public int getVersionNumber() {
        return this.serverDefinition.getVersionNumber();
    }

    public List<ClasspathElementDefinition> getClasspathElements() {
        return this.serverDefinition.getClasspathElements();
    }

    public IPath getPluginBaseDirectory() {
        return this.serverDefinition.getPluginBaseDirectory();
    }

    public int compareVersionTo(String otherVersion) {
        return this.serverDefinition.compareVersionTo(otherVersion);
    }

    public int compareTo(IServerDefinition o) {
        return this.serverDefinition.compareTo((Object)o);
    }

    public Collection<MuleLauncherClasspathElement> getMuleLauncherClasspathElements() {
        return this.serverDefinition.getMuleLauncherClasspathElements();
    }

    public MuleLauncherClasspathElement getToolingSupportFolder() {
        return this.serverDefinition.getToolingSupportFolder();
    }

    public MuleLauncherClasspathElement getEndorsedFolder() {
        return this.serverDefinition.getEndorsedFolder();
    }

    public MuleLauncherClasspathElement getMuleCorePerAppFolder() {
        return this.serverDefinition.getMuleCorePerAppFolder();
    }

    public LibraryFolderDefinition getMuleCoreLibrariesFolder() {
        return this.serverDefinition.getMuleCoreLibrariesFolder();
    }

    public LibraryFolderDefinition getLibraryFolderFolder(String label) {
        return this.serverDefinition.getLibraryFolderFolder(label);
    }

    public String toString() {
        return this.serverDefinition.toString();
    }

    public IMuleModuleManager getModuleManager() {
        return this.serverDefinition.getModuleManager();
    }

    public IPath getEnterpriseSourceFilePath() {
        return this.serverDefinition.getEnterpriseSourceFilePath();
    }

    public List<ConfigFolderDefinition> getConfigFolders() {
        return this.serverDefinition.getConfigFolders();
    }

    public RuntimeDefaultExtensions getRuntimeDefaultExtensions() {
        return this.serverDefinition.getRuntimeDefaultExtensions();
    }

    public void setEnterpriseSourceFilePath(IPath path) {
        this.serverDefinition.setEnterpriseSourceFilePath(path);
    }
}

