/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.PomMuleProjectModel;
import org.mule.tooling.core.m2.ProjectType;
import org.mule.tooling.maven.MavenMuleProjectDecorator;

public class MavenPomHelper {
    public static Optional<File> getTempCopyPomHandler(MavenMuleProjectDecorator mavenMuleProject, String artifactId, String groupId, String version, String description, ProjectType projectType) {
        Optional<File> result = Optional.empty();
        IFile newPomFile = mavenMuleProject.getMuleProject().getFile(".pom.xml");
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            Throwable throwable = null;
            Object var10_13 = null;
            try (FileInputStream fileInputStream = new FileInputStream(mavenMuleProject.getPomFile());){
                if (newPomFile.exists()) {
                    newPomFile.delete(true, (IProgressMonitor)monitor);
                }
                newPomFile.create((InputStream)fileInputStream, true, (IProgressMonitor)monitor);
                newPomFile.getLocation().toFile().deleteOnExit();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)"Problem while creating pom file", (Throwable)e);
        }
        catch (IOException fileNotFound) {
            MuleCorePlugin.logError((String)"Problem while creating pom file", (Throwable)fileNotFound);
        }
        if (newPomFile.exists()) {
            PomMuleProjectModel pomModel = PomMuleProjectModel.create((IFile)newPomFile);
            pomModel.setArtifactId(artifactId);
            pomModel.setDescription(description);
            pomModel.setGroupId(groupId);
            pomModel.setVersion(version);
            pomModel.setProjectType(projectType);
            result = Optional.ofNullable(pomModel.getPomFile());
        }
        return result;
    }
}

