/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.m2.query.MavenSearchEngine;
import org.mule.tooling.core.m2.query.QueryType;
import org.mule.tooling.maven.MavenCoordinatesValidator;
import org.mule.tooling.maven.query.internal.DefaultSearchEngine;
import org.mule.tooling.maven.query.internal.ReflectiveQueryType;
import org.mule.tooling.maven.query.internal.central.AsyncMavenArtifactDownloader;
import org.mule.tooling.maven.query.internal.central.MavenCentralAdvancedSearchBuilder;
import org.mule.tooling.maven.query.internal.central.MavenCentralClient;
import org.mule.tooling.maven.query.internal.central.MavenCentralQuickSearchBuilder;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEventHandler;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class MavenPlugin
implements BundleActivator {
    private static final String MAVEN_CENTRAL = "Maven Central";
    public static final String EMBEDDED_IN_STUDIO_FOLDER_INSTALLATION = "Embedded in Studio folder installation";
    public static final String PLUGIN_ID = "org.mule.tooling.maven";
    private static BundleContext context;
    private static EventBus eventBus;
    private static MavenSearchEngine mavenCentral;
    private EventBusHelper eventBusHelper = new EventBusHelper();

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        MavenCoordinatesValidator mavenCoordinatesValidator = new MavenCoordinatesValidator();
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), CoreEventTypes.POM_CHANGED, (IEventHandler)mavenCoordinatesValidator);
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), CoreEventTypes.POM_DELETED, (IEventHandler)mavenCoordinatesValidator);
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), CoreEventTypes.ON_MULE_PROJECT_EVENT, (IEventHandler)mavenCoordinatesValidator);
        this.eventBusHelper.registerListener(MavenPlugin.getEventBus(), CoreEventTypes.POM_DELETED, (IEventHandler)mavenCoordinatesValidator);
        Job.createSystem((String)"Initial Maven coordinates validation", monitor -> mavenCoordinatesValidator.validateAllProjects()).schedule();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.eventBusHelper.unregister();
        context = null;
    }

    public static ILog getLog() {
        return Platform.getLog((Bundle)context.getBundle());
    }

    public static void logInfo(String message) {
        MavenPlugin.getLog().log((IStatus)new Status(1, PLUGIN_ID, message));
    }

    public static void logError(String message) {
        MavenPlugin.getLog().log((IStatus)new Status(4, PLUGIN_ID, message));
    }

    public static void logError(String message, Throwable e) {
        MavenPlugin.getLog().log((IStatus)new Status(4, PLUGIN_ID, message, e));
    }

    public static void logWarning(String message, Throwable e) {
        MavenPlugin.getLog().log((IStatus)new Status(2, PLUGIN_ID, message, e));
    }

    public static void logWarning(String message) {
        MavenPlugin.getLog().log((IStatus)new Status(2, PLUGIN_ID, message));
    }

    public static EventBus getEventBus() {
        if (eventBus == null) {
            eventBus = new EventBus();
        }
        return eventBus;
    }

    public static List<MavenSearchEngine> getSearchEngines() {
        return Arrays.asList(MavenPlugin.getMavenCentralEngine());
    }

    public static MavenSearchEngine getMavenCentralEngine() {
        if (mavenCentral == null) {
            mavenCentral = MavenPlugin.createMavenCentral();
        }
        return mavenCentral;
    }

    private static MavenSearchEngine createMavenCentral() {
        ArrayList<QueryType> queryTypes = new ArrayList<QueryType>();
        queryTypes.add(new ReflectiveQueryType("Advanced Search", MavenCentralAdvancedSearchBuilder.class));
        queryTypes.add(new ReflectiveQueryType("Quick Search", MavenCentralQuickSearchBuilder.class));
        return new DefaultSearchEngine(MAVEN_CENTRAL, queryTypes, new AsyncMavenArtifactDownloader(MavenCentralClient.create()));
    }

    public static boolean trackBuildTimes() {
        return true;
    }
}

