/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.mule.tooling.core.impl.model.BaseMuleProject;
import org.mule.tooling.core.m2.IMavenPropertyResolver;
import org.mule.tooling.core.m2.PomMuleProjectModel;
import org.mule.tooling.core.m2.ProjectType;
import org.mule.tooling.core.m2.Repository;
import org.mule.tooling.core.m2.XmlEditionCallable;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.plugin.MavenBuildPlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.packageManager.PackagingOptions;
import org.mule.tooling.maven.MavenProjectComponent;

public class MavenMuleProjectDecorator {
    private static final String CUSTOM_FIELDS_POM_TAG = "fields";
    private static final String TAGS_POM_TAG = "tags";
    private static final String CATEGORIES_POM_TAG = "categories";
    private static Map<IMuleProject, MavenMuleProjectDecorator> decorators = new HashMap<IMuleProject, MavenMuleProjectDecorator>();
    private BaseMuleProject muleProject;
    private PomMuleProjectModel mulePom;
    private static final String MUNIT = "requested by MUnit - STUDIO-8527";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MavenMuleProjectDecorator decorate(IMuleProject muleProject) {
        if (decorators.containsKey(muleProject)) return decorators.get(muleProject);
        if (!(muleProject instanceof BaseMuleProject)) throw new IllegalArgumentException("project " + String.valueOf(muleProject) + " not an instance of " + BaseMuleProject.class.getSimpleName());
        BaseMuleProject baseMuleProject = (BaseMuleProject)muleProject;
        IFile muleProjectDescriptorFile = baseMuleProject.getMuleProjectDescriptorFile();
        if (!MavenMuleProjectDecorator.isPomFile(muleProjectDescriptorFile)) throw new IllegalArgumentException("project " + String.valueOf(muleProject) + " does not have a pom.xml file");
        MavenMuleProjectDecorator mavenProjectDecorator = new MavenMuleProjectDecorator(baseMuleProject);
        decorators.put(muleProject, mavenProjectDecorator);
        muleProject.getProjectComponent(MavenProjectComponent.class);
        return decorators.get(muleProject);
    }

    public static void removeProject(IMuleProject muleProject) {
        decorators.remove(muleProject);
    }

    private static boolean isPomFile(IFile file) {
        return "pom.xml".equals(file.getName());
    }

    private MavenMuleProjectDecorator(BaseMuleProject muleProject) {
        this.muleProject = muleProject;
        this.mulePom = (PomMuleProjectModel)muleProject.getMuleProjectModel();
    }

    public IMuleProject getMuleProject() {
        return this.muleProject;
    }

    public void addDependencies(List<MavenDependency> dependencies) {
        this.addMavenDependencies(dependencies);
    }

    public void addMavenDependencies(List<MavenDependency> dependencies) {
        this.mulePom.addMavenDependencies(dependencies);
    }

    public void addDependency(MavenDependency dependency) {
        this.mulePom.addMavenDependency(dependency);
    }

    public Optional<String> getResolvedMuleVersionInPom() {
        return this.mulePom.getResolvedMuleVersionInPom();
    }

    public File getPomFile() {
        return this.mulePom.getPomFile();
    }

    public String getGroupId() {
        return this.mulePom.getGroupId();
    }

    public String getArtifactId() {
        return this.mulePom.getArtifactId();
    }

    public String getDescription() {
        return this.mulePom.getDescription();
    }

    public String getVersion() {
        return this.mulePom.getVersion();
    }

    public String getName() {
        return this.mulePom.getName();
    }

    public void setArtifactId(String artifactId) {
        this.mulePom.setArtifactId(artifactId);
    }

    public Optional<ProjectType> getProjectType() {
        return this.mulePom.getProjectType();
    }

    public void setProjectType(ProjectType projectType) {
        this.mulePom.setProjectType(projectType);
    }

    public void removeMulePluginClassifier() {
        this.mulePom.removeMulePluginClassifier();
    }

    public void setDescription(String description) {
        this.mulePom.setDescription(description);
    }

    public void setGroupId(String groupId) {
        this.mulePom.setGroupId(groupId);
    }

    public void setVersion(String version) {
        this.mulePom.setVersion(version);
    }

    public void setName(String name) {
        this.mulePom.setName(name);
    }

    public void removeTags() {
        this.mulePom.removeProperty(TAGS_POM_TAG);
    }

    public void setTags(String tags) {
        this.mulePom.setProperty(TAGS_POM_TAG, tags);
    }

    public void removeCategories() {
        this.mulePom.removeProperty(CATEGORIES_POM_TAG);
    }

    public void setCategories(String content) {
        this.mulePom.setProperty(CATEGORIES_POM_TAG, content);
    }

    public void removeCustomFields() {
        this.mulePom.removeProperty(CUSTOM_FIELDS_POM_TAG);
    }

    public void setCustomFields(String content) {
        this.mulePom.setProperty(CUSTOM_FIELDS_POM_TAG, content);
    }

    public Optional<String> getTags() {
        return this.mulePom.getProperty(TAGS_POM_TAG);
    }

    public Optional<String> getCategories() {
        return this.mulePom.getProperty(CATEGORIES_POM_TAG);
    }

    public Optional<String> getCustomFields() {
        return this.mulePom.getProperty(CUSTOM_FIELDS_POM_TAG);
    }

    public boolean isPomWellFormed() {
        return this.mulePom.isPomWellFormed();
    }

    public void removeDependency(MavenDependency dependency) {
        this.mulePom.removeMavenDependency(dependency);
    }

    public boolean hasDependency(MavenDependency dependency, boolean considerVersion) {
        return this.mulePom.hasDependency(dependency, considerVersion);
    }

    public MavenDependency getDependency(MavenDependency dependency, boolean considerVersion) {
        return this.mulePom.getDependency(dependency, considerVersion);
    }

    public String getArtifactFinalName(PackagingOptions packagingOptions, Properties properties) {
        return this.mulePom.getArtifactFinalName(packagingOptions, properties);
    }

    public String getRawArtifactFinalName(PackagingOptions packagingOptions) {
        return this.mulePom.getRawArtifactFinalName(packagingOptions);
    }

    public IMavenPropertyResolver getPropertyResolver() {
        return this.mulePom.getPropertyResolver();
    }

    public File getLocallyInstalledArtifact() {
        return this.mulePom.getLocallyInstalledArtifact();
    }

    public boolean hasExchangeDocsFolder() {
        return this.muleProject.getFolder("exchange-docs").exists();
    }

    public List<Repository> getRepositories() {
        return this.mulePom.getRepositories();
    }

    public boolean addPlugin(String groupId, String artifactId, String version, XmlEditionCallable edition) {
        return this.mulePom.addPlugin(groupId, artifactId, version, edition);
    }

    public boolean hasPlugin(String groupId, String artifactId) {
        return this.mulePom.hasPlugin(groupId, artifactId);
    }

    public Optional<MavenBuildPlugin> getPlugin(String groupId, String artifactId) {
        return this.mulePom.getPlugin(groupId, artifactId);
    }

    public void removePlugin(String groupId, String artifactId) {
        this.mulePom.removePlugin(groupId, artifactId);
    }

    public Map<String, String> getProperties() {
        return this.mulePom.getProperties();
    }

    public boolean hasProperty(String name) {
        return this.mulePom.getProperties().containsKey(name);
    }

    public void setProperty(String name, String value) {
        this.mulePom.setProperty(name, value);
    }

    public void removeProperty(String name) {
        this.mulePom.removeProperty(name);
    }

    public void addTestResource(String resource) {
        this.mulePom.addTestResourceDirectory(resource);
    }

    public List<String> getTestResources() {
        return this.mulePom.getTestResourceDirectories();
    }

    public boolean hasTestResources(String resource) {
        return this.mulePom.hasTestResourceDirectory(resource);
    }

    public boolean editPluginConfiguration(String pluginGroupId, String pluginArtifactId, XmlEditionCallable edition) {
        return this.mulePom.editPluginConfiguration(pluginGroupId, pluginArtifactId, edition);
    }

    public boolean updatePluginVersion(String pluginGroupId, String pluginArtifactId, String version) {
        return this.mulePom.updatePluginVersion(pluginGroupId, pluginArtifactId, version);
    }

    public boolean hasPluginInLocalPom(String pluginGroupId, String pluginArtifactId) {
        return this.mulePom.hasPluginInLocalPom(pluginGroupId, pluginArtifactId);
    }

    public void addRepositoryBefore(String mavenFacadeIdV2, String string, String mavenFacadeUrl, Repository exchangeV1Repository) {
        this.mulePom.addRepositoryBefore(mavenFacadeIdV2, string, mavenFacadeUrl, exchangeV1Repository);
    }

    public void addRepository(String mavenFacadeIdV2, String string, String mavenFacadeUrl) {
        this.mulePom.addRepository(mavenFacadeIdV2, string, mavenFacadeUrl);
    }
}

