/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.event.IMuleProjectEventListener;
import org.mule.tooling.core.event.PomChangedEventHandler;
import org.mule.tooling.core.event.PomDeletedEventHandler;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.maven.MavenMuleProjectDecorator;

public class MavenCoordinatesValidator
implements PomChangedEventHandler,
PomDeletedEventHandler,
IMuleProjectEventListener {
    private static final String CONFLICTING_COORDINATES_KIND = "conflictingCoordinates";
    public static final String MAVEN_COORDINATES_JOB_FAMILY = "conflictingCoordinates";
    private Optional<MavenCoordinates> mavenCoordinates = Optional.empty();
    private final List<IMarker> markers = new ArrayList<IMarker>();

    public void onPomChanged(IResource pomResource, IProject project) {
        this.mavenCoordinates = this.getMavenCoordinates(project);
    }

    public void postPomChanged(IResource resource, IProject project) {
        Optional<MavenCoordinates> newMavenCoordinates = this.getMavenCoordinates(project);
        if (!this.mavenCoordinates.equals(newMavenCoordinates)) {
            IMuleProject[] muleProjects = MuleRuntime.getMuleProjects();
            this.validateAllProjects(this.mavenCoordinates, muleProjects);
            this.validateAllProjects(newMavenCoordinates, muleProjects);
        }
    }

    public void onPomDeleted(IResource pomResource, IProject project) {
        this.validateAllProjects();
    }

    public void onMuleProjectOpened(IProject project) {
        this.validateAllProjects(this.getMavenCoordinates(project), MuleRuntime.getMuleProjects());
    }

    public void onMuleProjectPreClose(IMuleProject muleProject) {
        Optional<MavenCoordinates> mavenCoordinates = this.getMavenCoordinates(muleProject);
        if (mavenCoordinates.isPresent()) {
            this.validateAllProjects(mavenCoordinates, MuleRuntime.getMuleProjects());
        } else {
            this.validateAllProjects();
        }
    }

    public void onMuleProjectClosed(IProject project) {
    }

    public void validateAllProjects() {
        IMuleProject[] muleProjects = MuleRuntime.getMuleProjects();
        Map projectsByMavenCoordinates = Arrays.stream(muleProjects).collect(Collectors.groupingBy(this::getMavenCoordinates, Collectors.toList()));
        projectsByMavenCoordinates.forEach(this::refreshMarkers);
    }

    private void validateAllProjects(Optional<MavenCoordinates> mavenCoordinates, IMuleProject[] muleProjects) {
        List<IMuleProject> filteredProjects = Arrays.stream(muleProjects).filter(muleProject -> this.getMavenCoordinates((IMuleProject)muleProject).equals(mavenCoordinates)).collect(Collectors.toList());
        this.refreshMarkers(mavenCoordinates, filteredProjects);
    }

    private void refreshMarkers(final Optional<MavenCoordinates> mavenCoordinates, final List<IMuleProject> projects) {
        Set pomFilesToClean = projects.stream().map(IMuleProject::getMuleProjectDescriptorFile).collect(Collectors.toSet());
        final List markersToDelete = this.markers.stream().filter(marker -> pomFilesToClean.contains(marker.getResource())).collect(Collectors.toList());
        this.markers.removeAll(markersToDelete);
        WorkspaceJob validationJob = new WorkspaceJob("Refresh POM validation markers"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                if (mavenCoordinates.isPresent() && projects.size() > 1) {
                    for (IMuleProject project : projects) {
                        if (!project.getProject().isAccessible()) continue;
                        IFile pomFile = project.getMuleProjectDescriptorFile();
                        try {
                            IMarker marker2 = MavenCoordinatesValidator.this.createPomMarker(pomFile, (MavenCoordinates)mavenCoordinates.get());
                            MavenCoordinatesValidator.this.markers.add(marker2);
                        }
                        catch (CoreException e) {
                            MuleCorePlugin.logError((String)("Error when creating marker for resource " + String.valueOf(pomFile)), (Throwable)e);
                        }
                    }
                }
                markersToDelete.forEach(marker -> {
                    try {
                        marker.delete();
                    }
                    catch (CoreException e) {
                        MuleCorePlugin.logError((String)("Error when deleting marker for resource " + String.valueOf(marker.getResource())), (Throwable)e);
                    }
                });
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return "conflictingCoordinates".equals(family);
            }
        };
        validationJob.setPriority(20);
        validationJob.schedule();
    }

    private IMarker createPomMarker(IFile pomFile, MavenCoordinates mavenCoordinates) throws CoreException {
        IMarker marker = pomFile.createMarker("org.mule.tooling.maven.pomError");
        marker.setAttribute("severity", 2);
        marker.setAttribute("lineNumber", 1);
        marker.setAttribute("pomErrorKind", (Object)"conflictingCoordinates");
        marker.setAttribute("message", (Object)("Conflicting Maven coordinates with other projects in workspace '" + String.valueOf(mavenCoordinates) + "'"));
        return marker;
    }

    private Optional<MavenCoordinates> getMavenCoordinates(IProject project) {
        IMuleProject muleProject = MuleRuntime.create((IProject)project);
        return this.getMavenCoordinates(muleProject);
    }

    private Optional<MavenCoordinates> getMavenCoordinates(IMuleProject muleProject) {
        return Optional.ofNullable(muleProject).filter(project -> project.getMuleProjectDescriptorFile().exists()).map(MavenMuleProjectDecorator::decorate).map(MavenCoordinates::from);
    }

    public static class MavenCoordinates {
        private final String groupId;
        private final String artifactId;
        private final String version;

        public static MavenCoordinates from(MavenMuleProjectDecorator decorated) {
            return new MavenCoordinates(decorated.getGroupId(), decorated.getArtifactId(), decorated.getVersion());
        }

        private MavenCoordinates(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public String toString() {
            return this.groupId + ":" + this.artifactId + ":" + this.version;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
            result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MavenCoordinates other = (MavenCoordinates)obj;
            if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
                return false;
            }
            if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
                return false;
            }
            return !(this.version == null ? other.version != null : !this.version.equals(other.version));
        }
    }
}

