/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.core.internal.processor;

import com.mulesoft.mule.runtime.core.internal.processor.TransformMessageProcessor;
import com.mulesoft.mule.runtime.core.internal.processor.TransformationTarget;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.el.CompiledExpression;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.exception.ResourceNotFoundException;
import org.mule.runtime.core.internal.el.ExpressionLanguageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoInstantiate
public abstract class BaseTransformationTarget
extends AbstractComponent
implements TransformationTarget {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformMessageProcessor.class);
    protected String resource;
    protected LazyValue<String> script = new LazyValue(this::loadExpression);
    private CompiledExpression compiledExpression;

    @Override
    public void initialize(ExpressionLanguage expressionLanguage) {
        this.compiledExpression = ExpressionLanguageUtils.compile((String)((String)this.script.get()), (ExpressionLanguage)expressionLanguage);
    }

    private String loadExpression() {
        if (this.script.isComputed()) {
            if (this.resource != null) {
                this.fail(String.format("Invalid configuration found for component [%s]: \n %s", this.getTargetName(), "Both [script] and [resource] parameters were provided, only one should be provided"));
            }
            return (String)this.script.get();
        }
        if (this.resource == null) {
            this.fail(String.format("Invalid configuration found for component [%s]: \n %s", this.getTargetName(), "No [script] nor [resource] parameters were provided, but one is required"));
        }
        return this.getResourceFrom(this.resource);
    }

    private String getResourceFrom(String resource) {
        String resourceFromStream = null;
        try (InputStream resourceAsStream = this.getResourceStream(resource);){
            resourceFromStream = IOUtils.toString((InputStream)resourceAsStream, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException | ResourceNotFoundException e) {
            this.fail(String.format("Invalid configuration found for parameter 'resource' in component [%s]: \n %s", this.getTargetName(), e.getMessage()));
        }
        return resourceFromStream;
    }

    private InputStream getResourceStream(String resource) throws FileNotFoundException {
        InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
        if (resourceAsStream == null) {
            resourceAsStream = new FileInputStream(resource);
        }
        return resourceAsStream;
    }

    @Override
    public void setScript(String script) {
        this.script = new LazyValue((Object)script);
    }

    @Override
    public String getScript() {
        return (String)this.script.get();
    }

    @Override
    public String getResource() {
        return this.resource;
    }

    @Override
    public void setResource(String resource) {
        this.resource = resource;
    }

    @Override
    public String getExpression() {
        return (String)this.script.get();
    }

    @Override
    public CompiledExpression getCompiledExpression() {
        return this.compiledExpression;
    }

    private void fail(String message) {
        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)message));
    }
}

