/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.gateway.events.collector.service;

import com.mulesoft.mule.runtime.gw.api.analytics.PolicyViolation;
import com.mulesoft.mule.runtime.gw.api.events.collector.service.EventsCollectorService;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultEventsCollectorService
implements EventsCollectorService {
    private final Map<String, PolicyViolation> violations = new ConcurrentHashMap<String, PolicyViolation>();
    private final Map<String, Map<String, Object>> violationExtraData = new ConcurrentHashMap<String, Map<String, Object>>();

    public String getName() {
        return "EventsCollectorService";
    }

    public void addPolicyViolation(String eventId, PolicyViolation violation) {
        this.violations.put(eventId, violation);
    }

    public void addExtraViolationData(String eventId, Map<String, Object> data) {
        this.violationExtraData.put(eventId, data);
    }

    public Optional<PolicyViolation> getPolicyViolation(String eventId) {
        return Optional.ofNullable(this.violations.get(eventId));
    }

    public Optional<Map<String, Object>> getExtraViolationData(String eventId) {
        return Optional.ofNullable(this.violationExtraData.get(eventId));
    }

    public Optional<PolicyViolation> removePolicyViolation(String eventId) {
        return Optional.ofNullable(this.violations.remove(eventId));
    }

    public Optional<Map<String, Object>> removeExtraViolationData(String eventId) {
        return Optional.ofNullable(this.violationExtraData.remove(eventId));
    }
}

