/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.artifact;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.deployment.meta.MuleDeployableModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.module.artifact.api.descriptor.AbstractArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidatorBuilder;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DescriptorLoaderRepository;
import org.mule.runtime.module.deployment.impl.internal.plugin.ArtifactPluginDescriptorLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDeployableDescriptorFactory<M extends MuleDeployableModel, T extends DeployableArtifactDescriptor>
extends AbstractArtifactDescriptorFactory<M, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDeployableDescriptorFactory.class);
    private final ArtifactPluginDescriptorLoader artifactPluginDescriptorLoader;

    public AbstractDeployableDescriptorFactory(ArtifactPluginDescriptorLoader artifactPluginDescriptorLoader, DescriptorLoaderRepository descriptorLoaderRepository, ArtifactDescriptorValidatorBuilder artifactDescriptorValidatorBuilder) {
        super(descriptorLoaderRepository, artifactDescriptorValidatorBuilder);
        Preconditions.checkArgument((artifactPluginDescriptorLoader != null ? 1 : 0) != 0, (String)"ApplicationPluginDescriptorFactory cannot be null");
        this.artifactPluginDescriptorLoader = artifactPluginDescriptorLoader;
    }

    protected void doDescriptorConfig(M artifactModel, T descriptor, File artifactLocation) {
        descriptor.setArtifactLocation(artifactLocation);
        descriptor.setRedeploymentEnabled(artifactModel.isRedeploymentEnabled());
        Set configs = artifactModel.getConfigs();
        if (configs != null && !configs.isEmpty()) {
            descriptor.setConfigResources(configs.stream().collect(Collectors.toSet()));
        } else {
            descriptor.setConfigResources(Collections.singleton(this.getDefaultConfigurationResource()));
        }
        try {
            descriptor.setPlugins(this.createArtifactPluginDescriptors(descriptor));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        descriptor.setLogConfigFile(this.getLogConfigFile(artifactModel));
        descriptor.setSupportedJavaVersions(artifactModel.getSupportedJavaVersions());
    }

    protected File getLogConfigFile(M artifactModel) {
        File logConfigFile = null;
        if (artifactModel.getLogConfigFile() != null) {
            Path logConfigFilePath = new File(artifactModel.getLogConfigFile()).toPath();
            Path muleHomeFolderPath = MuleFoldersUtil.getMuleHomeFolder().toPath();
            logConfigFile = muleHomeFolderPath.resolve(logConfigFilePath).toFile();
        }
        return logConfigFile;
    }

    protected abstract String getDefaultConfigurationResource();

    private Set<ArtifactPluginDescriptor> createArtifactPluginDescriptors(T descriptor) throws IOException {
        HashSet<ArtifactPluginDescriptor> pluginDescriptors = new HashSet<ArtifactPluginDescriptor>();
        for (BundleDependency bundlePluginDependency : descriptor.getClassLoaderConfiguration().getDependencies()) {
            if (!bundlePluginDependency.getDescriptor().isPlugin()) continue;
            if (bundlePluginDependency.getBundleUri() == null) {
                LOGGER.warn(String.format("Plugin '%s' is declared as 'provided' which means that it will not be added to the artifact's classpath", bundlePluginDependency.getDescriptor()));
                continue;
            }
            File pluginFile = new File(bundlePluginDependency.getBundleUri());
            pluginDescriptors.add(this.artifactPluginDescriptorLoader.load(pluginFile, bundlePluginDependency.getDescriptor(), (ArtifactDescriptor)descriptor));
        }
        return pluginDescriptors;
    }
}

