/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.splitter.handlers;

import java.util.HashSet;
import java.util.Optional;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.dfl.ui.css.IMappingIndicatorStyle;
import org.mule.tooling.dfl.ui.graphical.ConnectorEndpoint;
import org.mule.tooling.dfl.ui.graphical.WeaveUIConstants;
import org.mule.tooling.dfl.ui.graphical.model.ITreeGraphicalMapping;
import org.mule.tooling.dfl.ui.graphical.model.LambdaOperator;
import org.mule.tooling.dfl.ui.graphical.model.containers.IMappingInfo;
import org.mule.tooling.dfl.ui.graphical.model.containers.LambdaMappingInfo;
import org.mule.tooling.dfl.ui.graphical.providers.IConnectorProvider;
import org.mule.tooling.dfl.ui.graphical.util.TreeViewerHelper;
import org.mule.tooling.ui.splitter.ISashPaintListener;
import org.mule.tooling.ui.splitter.Splitter;

public abstract class AbstractSashPaintListener
implements ISashPaintListener {
    public static final int LINE_COORD_X = 3;
    public static final int RECTANGLE_WIDTH = 3;
    public static final int SECOND_RECTANGE_COORD_X = 4;
    public static final int MIDDLE_SASH_WIDTH = Splitter.SASH_WIDTH / 2;
    protected Sash sash;
    protected Splitter splitter;
    protected IConnectorProvider connectorProvider;
    private IMappingIndicatorStyle style;
    private boolean paintSashes;
    private Image image;
    private int treeItemHeight = -1;
    private Rectangle treeClientArea;

    public AbstractSashPaintListener(Splitter splitter, Sash sash, IMappingIndicatorStyle style) {
        this.sash = sash;
        this.splitter = splitter;
        this.style = style;
        this.paintSashes = true;
        sash.addDisposeListener(e -> Optional.ofNullable(this.image).ifPresent(it -> it.dispose()));
    }

    public void setConnectorProvider(IConnectorProvider connectorProvider) {
        this.connectorProvider = connectorProvider;
    }

    public abstract Color getLeftColor();

    public abstract Color getRightColor();

    public abstract int getInitialCoordX();

    public abstract int getFinalCoordX();

    public void paintControl(PaintEvent e) {
        try {
            if (!this.splitter.isDragging()) {
                if (this.image != null) {
                    this.image.dispose();
                }
                this.image = new Image((Device)Display.getDefault(), this.sash.getBounds());
                GC gcImage = new GC((Drawable)this.image);
                gcImage.setAlpha(255);
                gcImage.setLineWidth(0);
                Rectangle bounds = this.sash.getBounds();
                gcImage.setBackground(this.getLeftColor());
                gcImage.fillRectangle(0, 0, 3, bounds.height);
                gcImage.setForeground(this.style.getBorderColor());
                gcImage.drawLine(3, 0, 3, bounds.height);
                gcImage.setBackground(this.getRightColor());
                gcImage.fillRectangle(4, 0, 3, bounds.height);
                gcImage.setLineWidth(0);
                gcImage.setAntialias(1);
                if (this.paintSashes && this.connectorProvider != null) {
                    FilteredTree filteredTree = this.connectorProvider.getFilteredTree();
                    this.calculateTreeBounds(filteredTree);
                    this.paintContextItems(gcImage);
                    gcImage.setAlpha(255);
                    gcImage.setLineStyle(1);
                    this.paintVisibleItems(gcImage, this.connectorProvider.getItems());
                    this.paintMappedItems(gcImage);
                }
                e.gc.drawImage(this.image, 0, 0);
                gcImage.dispose();
            } else {
                e.gc.drawImage(this.image, 0, 0);
            }
        }
        catch (Exception exception) {
            MuleCorePlugin.logError((String)"Error painting sashes", (Throwable)exception);
        }
    }

    protected void paintContextItems(GC gc) {
        if (this.connectorProvider.getFilteredTree().isDisposed()) {
            return;
        }
        HashSet<ConnectorEndpoint> connectorEndpoints = new HashSet<ConnectorEndpoint>();
        TreeItem[] selection = this.connectorProvider.getSelection();
        Optional<TreeItem> rootOfSelectedContext = TreeViewerHelper.findSelectedContext(selection, this.connectorProvider.getMappings());
        int margin = this.splitter.getMargin();
        FilteredTree filteredTree = this.connectorProvider.getFilteredTree();
        for (ITreeGraphicalMapping mapping : this.connectorProvider.getMappings()) {
            LambdaMappingInfo lambda;
            TreeItem treeItem = this.connectorProvider.getConnectorItem(mapping);
            TreeItem mirrorElement = this.connectorProvider.getMirrorConnectorItem(mapping);
            if (treeItem == null || mirrorElement == null || treeItem.isDisposed()) continue;
            IMappingInfo sourceElement = mapping.getSourceElement();
            if (!TreeViewerHelper.isVisible(treeItem) || !(sourceElement instanceof LambdaMappingInfo) || !LambdaOperator.MAP.equals((Object)(lambda = (LambdaMappingInfo)sourceElement).getOperator()) || !connectorEndpoints.add(new ConnectorEndpoint(treeItem, mirrorElement))) continue;
            TreeItem visibleItem = TreeViewerHelper.getNearestVisibleParentItem(treeItem);
            int initialY = TreeViewerHelper.getInitialYAxisFromItem(filteredTree.getViewer(), visibleItem, this.treeClientArea);
            int drawingInitialY = initialY + margin;
            int contextHeight = TreeViewerHelper.calculateHeight(treeItem, this.treeItemHeight);
            boolean isMappingInsideContext = this.connectorProvider.isMappingInsideContext(rootOfSelectedContext, mapping);
            gc.setLineStyle(isMappingInsideContext ? 1 : 3);
            gc.setAlpha(isMappingInsideContext ? 51 : 25);
            gc.setBackground(WeaveUIConstants.CORE_BLUE_2);
            gc.fillRectangle(this.getInitialCoordX(), drawingInitialY, 3, contextHeight);
            if (!isMappingInsideContext) continue;
            gc.setAlpha(25);
            gc.setForeground(WeaveUIConstants.CORE_BLUE_4);
            gc.drawLine(this.getInitialCoordX(), drawingInitialY, this.getFinalCoordX(), drawingInitialY);
            gc.drawLine(this.getInitialCoordX(), drawingInitialY + contextHeight, this.getFinalCoordX(), drawingInitialY + contextHeight);
        }
    }

    protected void paintVisibleItems(GC gc, TreeItem[] items) {
        int margin = this.splitter.getMargin();
        FilteredTree filteredTree = this.connectorProvider.getFilteredTree();
        Rectangle bounds = filteredTree.getBounds();
        int downMargin = bounds.y + bounds.height - margin;
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            int middleYAxisFromItem;
            int drawingInitialY;
            TreeItem treeItem = treeItemArray[n2];
            if (TreeViewerHelper.isVisible(treeItem) && (drawingInitialY = (middleYAxisFromItem = TreeViewerHelper.getMiddleYAxisFromItem(filteredTree.getViewer(), treeItem, this.treeItemHeight, this.treeClientArea)) + margin) >= margin && middleYAxisFromItem <= downMargin) {
                gc.setBackground(this.style.getMappingPendingIndicatorColor());
                gc.fillOval(0, drawingInitialY - MIDDLE_SASH_WIDTH, Splitter.SASH_WIDTH, Splitter.SASH_WIDTH);
                gc.setForeground(this.style.getBorderColor());
                gc.drawOval(0, drawingInitialY - MIDDLE_SASH_WIDTH, Splitter.SASH_WIDTH - 1, Splitter.SASH_WIDTH - 1);
            }
            this.paintVisibleItems(gc, treeItem.getItems());
            ++n2;
        }
    }

    protected void paintMappedItems(GC gc) {
        HashSet<TreeItem> mappingIndicators = new HashSet<TreeItem>();
        int margin = this.splitter.getMargin();
        FilteredTree filteredTree = this.connectorProvider.getFilteredTree();
        Rectangle bounds = filteredTree.getBounds();
        int downMargin = bounds.y + bounds.height - margin;
        for (ITreeGraphicalMapping mapping : this.connectorProvider.getMappings()) {
            int middleYAxisFromItem;
            int drawingInitialY;
            IMappingInfo sourceElement;
            TreeItem treeItem = this.connectorProvider.getConnectorItem(mapping);
            if (treeItem == null || treeItem.isDisposed() || (sourceElement = mapping.getSourceElement()).isEmpty() || !TreeViewerHelper.isVisible(treeItem) || (drawingInitialY = (middleYAxisFromItem = TreeViewerHelper.getMiddleYAxisFromItem(filteredTree.getViewer(), treeItem, this.treeItemHeight, this.treeClientArea)) + margin) < margin || middleYAxisFromItem > downMargin || !mappingIndicators.add(treeItem)) continue;
            boolean selected = this.connectorProvider.isSelected(mapping);
            boolean isHover = this.connectorProvider.isHover(mapping, this.splitter.getHoverItem());
            gc.setBackground(this.getMappedColor(isHover, selected));
            gc.fillOval(0, drawingInitialY - MIDDLE_SASH_WIDTH, Splitter.SASH_WIDTH, Splitter.SASH_WIDTH);
            gc.setForeground(this.getMappedColor(isHover, selected));
            gc.drawOval(0, drawingInitialY - MIDDLE_SASH_WIDTH, Splitter.SASH_WIDTH - 1, Splitter.SASH_WIDTH - 1);
        }
    }

    private void calculateTreeBounds(FilteredTree filteredTree) {
        if (this.treeItemHeight == -1) {
            this.treeItemHeight = filteredTree.getViewer().getTree().getItemHeight();
        }
        this.treeClientArea = filteredTree.getViewer().getTree().getClientArea();
    }

    private Color getMappedColor(boolean isHover, boolean selected) {
        Color mappedColor = this.style.getMappingIndicatorColor();
        if (isHover && !selected) {
            mappedColor = this.style.getMappingHoverIndicatorColor();
        } else if (selected) {
            mappedColor = this.style.getMappingSelectedIndicatorColor();
        }
        return mappedColor;
    }

    public IMappingIndicatorStyle getStyle() {
        return this.style;
    }

    public void setPaintSashes(boolean paintSashes) {
        this.paintSashes = paintSashes;
    }
}

