/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.wizard;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.mule.tooling.dfl.ui.utils.PluginUtils;
import org.mule.tooling.dfl.ui.utils.ResourcesHelper;
import org.mule.tooling.dfl.ui.wizard.NewDFLWizardPage;

public class NewDFLWizard
extends Wizard
implements INewWizard {
    private NewDFLWizardPage page;
    private IStructuredSelection selection;

    public NewDFLWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new NewDFLWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        Object fileName = this.page.getFileName();
        fileName = ((String)fileName).endsWith(".dwl") ? fileName : (String)fileName + ".dwl";
        this.page.setFileName((String)fileName);
        IFile currentFile = this.page.createNewFile();
        try {
            String fileContent = ResourcesHelper.readFileContent("templates/initial-file.dfl");
            currentFile.setContents((InputStream)new ByteArrayInputStream(fileContent.getBytes()), 2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            PluginUtils.logError("Error creating file", e);
        }
        return this.openEditorForFile(currentFile);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    private boolean openEditorForFile(IFile file) {
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
            IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
            BasicNewResourceWizard.selectAndReveal((IResource)file, (IWorkbenchWindow)workbench.getActiveWorkbenchWindow());
        }
        catch (PartInitException e) {
            PluginUtils.logError("Error opening file", e);
        }
        return true;
    }
}

